/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.playList;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.gui.views.panels.PlayListControlsPanel;
import net.sourceforge.atunes.gui.views.panels.PlayListPanel;
import net.sourceforge.atunes.kernel.controllers.model.AbstractSimpleController;
import net.sourceforge.atunes.kernel.controllers.playList.PlayListKeyListener;
import net.sourceforge.atunes.kernel.controllers.playList.PlayListListener;
import net.sourceforge.atunes.kernel.modules.filter.FilterHandler;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListTableModel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;

public final class PlayListController
extends AbstractSimpleController<PlayListPanel> {
    private Rectangle visibleRect;

    public PlayListController(PlayListPanel playListPanel) {
        super(playListPanel);
        this.addBindings();
        this.addStateBindings();
    }

    @Override
    protected void addBindings() {
        PlayListTable playListTable = ((PlayListPanel)this.getComponentControlled()).getPlayListTable();
        playListTable.addKeyListener(new PlayListKeyListener(this));
        PlayListListener playListListener = new PlayListListener(playListTable, this);
        playListTable.addMouseListener(playListListener);
        playListTable.getSelectionModel().addListSelectionListener(playListListener);
    }

    @Override
    protected void addStateBindings() {
    }

    public void deleteSelection() {
        this.getLogger().debug("CONTROLLER  ");
        PlayListTable playListTable = GuiHandler.getInstance().getPlayListTable();
        int[] nArray = playListTable.getSelectedRows();
        if (nArray.length > 0) {
            ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getSelectionModel().clearSelection();
            PlayListHandler.getInstance().removeAudioObjects(nArray);
        }
    }

    public JScrollPane getMainPlayListScrollPane() {
        return ((PlayListPanel)this.getComponentControlled()).getPlayListTableScroll();
    }

    public PlayListTable getMainPlayListTable() {
        return ((PlayListPanel)this.getComponentControlled()).getPlayListTable();
    }

    public void moveDown() {
        this.getLogger().debug("CONTROLLER  ");
        PlayListTable playListTable = GuiHandler.getInstance().getPlayListTable();
        int[] nArray = playListTable.getSelectedRows();
        if (nArray.length > 0 && nArray[nArray.length - 1] < playListTable.getRowCount() - 1) {
            PlayListHandler.getInstance().moveDown(nArray);
            this.refreshPlayList();
            ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getSelectionModel().setSelectionInterval(nArray[0] + 1, nArray[nArray.length - 1] + 1);
        }
    }

    public void moveToBottom() {
        this.getLogger().debug("CONTROLLER  ");
        PlayListTable playListTable = GuiHandler.getInstance().getPlayListTable();
        int[] nArray = playListTable.getSelectedRows();
        if (nArray.length > 0 && nArray[nArray.length - 1] < playListTable.getRowCount() - 1) {
            PlayListHandler.getInstance().moveToBottom(nArray);
            this.refreshPlayList();
            ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getSelectionModel().setSelectionInterval(((PlayListPanel)this.getComponentControlled()).getPlayListTable().getRowCount() - nArray.length, ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getRowCount() - 1);
        }
    }

    public void moveToTop() {
        this.getLogger().debug("CONTROLLER  ");
        PlayListTable playListTable = GuiHandler.getInstance().getPlayListTable();
        int[] nArray = playListTable.getSelectedRows();
        if (nArray.length > 0 && nArray[0] > 0) {
            PlayListHandler.getInstance().moveToTop(nArray);
            this.refreshPlayList();
            ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getSelectionModel().setSelectionInterval(0, nArray.length - 1);
        }
    }

    public void moveUp() {
        this.getLogger().debug("CONTROLLER  ");
        PlayListTable playListTable = GuiHandler.getInstance().getPlayListTable();
        int[] nArray = playListTable.getSelectedRows();
        if (nArray.length > 0 && nArray[0] > 0) {
            PlayListHandler.getInstance().moveUp(nArray);
            this.refreshPlayList();
            ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getSelectionModel().setSelectionInterval(nArray[0] - 1, nArray[nArray.length - 1] - 1);
        }
    }

    @Override
    protected void notifyReload() {
    }

    public void playSelectedAudioObject() {
        int n = ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getSelectedRow();
        PlayListHandler.getInstance().setPositionToPlayInVisiblePlayList(n);
        PlayerHandler.getInstance().playCurrentAudioObject(false);
    }

    public void scrollPlayList(boolean bl) {
        if (PlayListHandler.getInstance().getCurrentPlayList(true) != null) {
            this.scrollPlayList(PlayListHandler.getInstance().getCurrentAudioObjectIndexInVisiblePlayList(), bl);
        }
    }

    private synchronized void scrollPlayList(int n, boolean bl) {
        int n2;
        if (!ApplicationState.getInstance().isAutoScrollPlayListEnabled() && !bl) {
            return;
        }
        if (!PlayListHandler.getInstance().isActivePlayListVisible()) {
            return;
        }
        this.getLogger().debug("CONTROLLER  ", "Scrolling PlayList");
        this.visibleRect = (Rectangle)((PlayListPanel)this.getComponentControlled()).getPlayListTable().getVisibleRect().clone();
        int n3 = ((PlayListPanel)this.getComponentControlled()).getPlayListTable().getCellRect((int)n, (int)0, (boolean)true).height;
        this.visibleRect.y = this.visibleRect.height == 0 ? (n + 1) * n3 : (n2 = (n + 1) * n3 - this.visibleRect.height / 2);
        this.visibleRect.y = this.visibleRect.y >= 0 ? this.visibleRect.y : 0;
        Timer timer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((PlayListPanel)PlayListController.this.getComponentControlled()).getPlayListTable().scrollRectToVisible(PlayListController.this.visibleRect);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public PlayListControlsPanel getPlayListControlsPanel() {
        return ((PlayListPanel)this.getComponentControlled()).getPlayListControls();
    }

    public void refreshPlayList() {
        int[] nArray = GuiHandler.getInstance().getPlayListTable().getSelectedRows();
        ((PlayListTableModel)GuiHandler.getInstance().getPlayListTable().getModel()).refresh(0);
        for (int n : nArray) {
            GuiHandler.getInstance().getPlayListTable().getSelectionModel().addSelectionInterval(n, n);
        }
    }

    public void reapplyFilter() {
        this.getLogger().debug("CONTROLLER  ");
        if (PlayListHandler.getInstance().isFiltered()) {
            PlayListHandler.getInstance().setFilter(FilterHandler.getInstance().getFilter());
        }
    }
}

