/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.controllers.navigation;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.gui.views.panels.NavigationTablePanel;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.navigator.AbstractNavigationView;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.model.AudioObject;

public final class NavigationTableMouseListener
extends MouseAdapter {
    private NavigationController controller;
    private NavigationTablePanel panel;

    public NavigationTableMouseListener(NavigationController navigationController, NavigationTablePanel navigationTablePanel) {
        this.controller = navigationController;
        this.panel = navigationTablePanel;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        AbstractNavigationView abstractNavigationView = NavigationHandler.getInstance().getCurrentView();
        if (mouseEvent.getButton() == 3) {
            this.controller.setPopupMenuCaller(this.panel.getNavigationTable());
            int[] nArray = this.panel.getNavigationTable().getSelectedRows();
            int n = this.panel.getNavigationTable().rowAtPoint(mouseEvent.getPoint());
            boolean bl = false;
            for (int i = 0; !bl && i < nArray.length; ++i) {
                if (nArray[i] != n) continue;
                bl = true;
            }
            if (!bl) {
                this.panel.getNavigationTable().getSelectionModel().setSelectionInterval(n, n);
            }
            abstractNavigationView.updateTablePopupMenuWithTableSelection(this.panel.getNavigationTable(), mouseEvent);
            abstractNavigationView.getTablePopupMenu().show(this.controller.getPopupMenuCaller(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getClickCount() == 2) {
            int[] nArray = this.panel.getNavigationTable().getSelectedRows();
            List<AudioObject> list = ((NavigationTableModel)this.panel.getNavigationTable().getModel()).getAudioObjectsAt(nArray);
            if (list != null && list.size() >= 1) {
                PlayListHandler.getInstance().addToPlayList(list);
            }
        }
    }
}

