/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.model.NavigationTableModel;
import net.sourceforge.atunes.kernel.ControllerProxy;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class ShowNavigatorTableItemInfoAction
extends AbstractAction {
    private static final long serialVersionUID = -2006569851431046347L;

    ShowNavigatorTableItemInfoAction() {
        super(I18nUtils.getString("INFO"), Images.getImage("info.png"));
        this.putValue("ShortDescription", I18nUtils.getString("INFO_BUTTON_TOOLTIP"));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getSelectedRow();
        AudioObject audioObject = ((NavigationTableModel)ControllerProxy.getInstance().getNavigationController().getNavigationTablePanel().getNavigationTable().getModel()).getAudioObjectAt(n);
        GuiHandler.getInstance().showPropertiesDialog(audioObject);
    }

    @Override
    public boolean isEnabledForNavigationTableSelection(List<AudioObject> list) {
        return list.size() == 1;
    }
}

