/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.actions.Actions;
import net.sourceforge.atunes.kernel.actions.CollapseTreesAction;
import net.sourceforge.atunes.kernel.actions.ExpandTreesAction;
import net.sourceforge.atunes.kernel.controllers.navigation.NavigationController;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public class ShowFoldersInNavigatorAction
extends AbstractAction {
    private static final long serialVersionUID = -3422236983060989235L;

    ShowFoldersInNavigatorAction() {
        super(I18nUtils.getString("SHOW_FOLDERS"), Images.getImage("repository.png"));
        this.putValue("ShortDescription", I18nUtils.getString("SHOW_FOLDERS"));
        this.putValue("SwingSelectedKey", ApplicationState.getInstance().getViewMode() == NavigationController.ViewMode.FOLDER);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (ApplicationState.getInstance().getViewMode() != NavigationController.ViewMode.FOLDER) {
            ApplicationState.getInstance().setViewMode(NavigationController.ViewMode.FOLDER);
            NavigationHandler.getInstance().refreshCurrentView();
            Actions.getAction(CollapseTreesAction.class).setEnabled(true);
            Actions.getAction(ExpandTreesAction.class).setEnabled(true);
        }
    }
}

