/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.navigator.PodcastNavigationView;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeed;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedHandler;
import net.sourceforge.atunes.utils.I18nUtils;

public class RemovePodcastFeedAction
extends AbstractAction {
    private static final long serialVersionUID = -7470658878101801512L;

    RemovePodcastFeedAction() {
        super(I18nUtils.getString("REMOVE_PODCAST_FEED"), Images.getImage("delete.png"));
        this.putValue("ShortDescription", I18nUtils.getString("REMOVE_PODCAST_FEED"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        TreePath[] treePathArray = NavigationHandler.getInstance().getView(PodcastNavigationView.class).getTree().getSelectionPaths();
        HashSet<PodcastFeed> hashSet = new HashSet<PodcastFeed>();
        for (TreePath treePath : treePathArray) {
            PodcastFeed podcastFeed = (PodcastFeed)((DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject();
            hashSet.add(podcastFeed);
        }
        for (PodcastFeed podcastFeed : hashSet) {
            PodcastFeedHandler.getInstance().removePodcastFeed(podcastFeed);
        }
    }

    @Override
    public boolean isEnabledForNavigationTreeSelection(boolean bl, List<DefaultMutableTreeNode> list) {
        return !bl && !list.isEmpty();
    }
}

