/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public class NormalizeModeAction
extends AbstractAction {
    private static final long serialVersionUID = 6993968558006979367L;
    private Timer timer;

    public NormalizeModeAction() {
        super(I18nUtils.getString("NORMALIZE"), Images.getImage("normalization.png"));
        this.putValue("ShortDescription", I18nUtils.getString("NORMALIZE"));
        this.putValue("SwingSelectedKey", ApplicationState.getInstance().isUseNormalisation());
        this.timer = new Timer(1000, new ActionListener(){
            boolean showWarning;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (this.showWarning) {
                    NormalizeModeAction.this.putValue("SmallIcon", Images.getImage("normalization.png"));
                } else {
                    NormalizeModeAction.this.putValue("SmallIcon", Images.getImage("warning.png"));
                }
                this.showWarning = !this.showWarning;
            }
        });
        if (ApplicationState.getInstance().isUseNormalisation()) {
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = !ApplicationState.getInstance().isUseNormalisation();
        ApplicationState.getInstance().setUseNormalisation(bl);
        PlayerHandler.getInstance().applyNormalization();
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.putValue("SmallIcon", Images.getImage("normalization.png"));
        } else {
            this.timer.start();
        }
    }
}

