/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import net.sourceforge.atunes.gui.views.dialogs.MultiFolderSelectionDialog;
import net.sourceforge.atunes.gui.views.dialogs.SelectorDialog;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class ImportToRepositoryAction
extends AbstractAction {
    private static final long serialVersionUID = -5708270585764283210L;

    ImportToRepositoryAction() {
        super(StringUtils.getString(I18nUtils.getString("IMPORT"), "..."));
        this.putValue("ShortDescription", StringUtils.getString(I18nUtils.getString("IMPORT"), "..."));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        List<File> list;
        if (RepositoryHandler.getInstance().repositoryIsNull()) {
            GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("SELECT_REPOSITORY_BEFORE_IMPORT"));
            return;
        }
        MultiFolderSelectionDialog multiFolderSelectionDialog = GuiHandler.getInstance().getMultiFolderSelectionDialog();
        multiFolderSelectionDialog.setTitle(I18nUtils.getString("IMPORT"));
        multiFolderSelectionDialog.setText(I18nUtils.getString("SELECT_FOLDERS_TO_IMPORT"));
        multiFolderSelectionDialog.startDialog(null);
        if (!multiFolderSelectionDialog.isCancelled() && !(list = multiFolderSelectionDialog.getSelectedFolders()).isEmpty()) {
            String string;
            String[] stringArray = new String[RepositoryHandler.getInstance().getFoldersCount()];
            for (int i = 0; i < RepositoryHandler.getInstance().getFolders().size(); ++i) {
                stringArray[i] = RepositoryHandler.getInstance().getFolders().get(i).getAbsolutePath();
            }
            if (stringArray.length > 1) {
                SelectorDialog selectorDialog = new SelectorDialog((Window)GuiHandler.getInstance().getFrame().getFrame(), I18nUtils.getString("SELECT_REPOSITORY_FOLDER_TO_IMPORT"), stringArray, null);
                selectorDialog.setVisible(true);
                string = selectorDialog.getSelection();
                if (string == null) {
                    string = stringArray[0];
                }
            } else {
                string = stringArray[0];
            }
            RepositoryHandler.getInstance().importFolders(list, string);
        }
    }
}

