/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import net.sourceforge.atunes.gui.views.dialogs.ExportOptionsDialog;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.navigator.NavigationHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.process.ProcessListener;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.kernel.modules.repository.processes.ExportFilesProcess;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public class ExportAction
extends AbstractAction {
    private static final long serialVersionUID = -6661702915765846089L;

    ExportAction() {
        super(StringUtils.getString(I18nUtils.getString("EXPORT"), "..."));
        this.putValue("ShortDescription", StringUtils.getString(I18nUtils.getString("EXPORT"), "..."));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        ExportOptionsDialog exportOptionsDialog = GuiHandler.getInstance().getExportDialog();
        exportOptionsDialog.startDialog();
        if (!exportOptionsDialog.isCancel()) {
            String string = exportOptionsDialog.getExportLocation();
            boolean bl = exportOptionsDialog.exportNavigatorSelection();
            if (string != null && !string.trim().equals("")) {
                boolean bl2 = new File(string).exists();
                boolean bl3 = false;
                if (!bl2 && GuiHandler.getInstance().showConfirmationDialog(I18nUtils.getString("DIR_NO_EXISTS"), I18nUtils.getString("INFO")) == 0) {
                    bl2 = new File(string).mkdir();
                    bl3 = true;
                }
                if (bl2) {
                    List<AudioFile> list = bl ? AudioFile.getAudioFiles(NavigationHandler.getInstance().getCurrentView().getSelectedAudioObjects()) : AudioFile.getAudioFiles(PlayListHandler.getInstance().getSelectedAudioObjects());
                    ExportFilesProcess exportFilesProcess = new ExportFilesProcess(list, string);
                    exportFilesProcess.addProcessListener(new ExportProcessListener());
                    exportFilesProcess.execute();
                } else if (bl3) {
                    GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("COULD_NOT_CREATE_DIR"));
                }
            } else {
                GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("INCORRECT_EXPORT_PATH"));
            }
        }
    }

    private static class ExportProcessListener
    implements ProcessListener {
        private ExportProcessListener() {
        }

        @Override
        public void processCanceled() {
        }

        @Override
        public void processFinished(boolean bl) {
            SwingUtilities.invokeLater(new ShowErrorDialogRunnable(bl));
        }

        private static final class ShowErrorDialogRunnable
        implements Runnable {
            private final boolean ok;

            private ShowErrorDialogRunnable(boolean bl) {
                this.ok = bl;
            }

            @Override
            public void run() {
                if (!this.ok) {
                    GuiHandler.getInstance().showErrorDialog(I18nUtils.getString("ERRORS_IN_EXPORT_PROCESS"));
                }
            }
        }
    }
}

