/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.kernel.actions.AbstractActionOverSelectedObjects;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.repository.AudioObjectComparator;
import net.sourceforge.atunes.kernel.modules.repository.RepositoryHandler;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.I18nUtils;

public class CreatePlayListWithSelectedArtistsAction
extends AbstractActionOverSelectedObjects<AudioObject> {
    private static final long serialVersionUID = 242525309967706255L;

    CreatePlayListWithSelectedArtistsAction() {
        super(I18nUtils.getString("SET_ARTIST_AS_PLAYLIST"), Images.getImage("artist.png"), AudioObject.class);
        this.putValue("ShortDescription", I18nUtils.getString("ARTIST_BUTTON_TOOLTIP"));
        this.setEnabled(false);
    }

    @Override
    protected void performAction(List<AudioObject> list) {
        Object object;
        Map<String, Artist> map = RepositoryHandler.getInstance().getArtistStructure();
        ArrayList<Artist> arrayList = new ArrayList<Artist>();
        for (AudioObject object2 : list) {
            Artist artist;
            object = object2.getArtist();
            if (!map.containsKey(object) || arrayList.contains(artist = map.get(object))) continue;
            arrayList.add(artist);
        }
        for (Artist artist : arrayList) {
            object = AudioFile.getAudioObjects(RepositoryHandler.getInstance().getAudioFilesForArtists(Collections.singletonMap(artist.getName(), artist)));
            AudioObjectComparator.sort((List<AudioObject>)object);
            PlayListHandler.getInstance().newPlayList(artist.getName(), (List<AudioObject>)object);
        }
    }

    @Override
    public boolean isEnabledForPlayListSelection(List<AudioObject> list) {
        return !list.isEmpty();
    }
}

