/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.kernel.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import net.sourceforge.atunes.gui.model.AudioObjectsSource;
import net.sourceforge.atunes.kernel.actions.AbstractAction;
import net.sourceforge.atunes.model.AudioObject;

public abstract class AbstractActionOverSelectedObjects<T extends AudioObject>
extends AbstractAction {
    private static final long serialVersionUID = 1673432955671008277L;
    private static Map<Component, AudioObjectsSource> registeredComponents = new HashMap<Component, AudioObjectsSource>();
    private Class<T> objectsClass;

    public AbstractActionOverSelectedObjects(Class<T> clazz) {
        this.objectsClass = clazz;
    }

    public AbstractActionOverSelectedObjects(String string, Class<T> clazz) {
        super(string);
        this.objectsClass = clazz;
    }

    public AbstractActionOverSelectedObjects(String string, Icon icon, Class<T> clazz) {
        super(string, icon);
        this.objectsClass = clazz;
    }

    static final void addRegisteredComponent(Component component, AudioObjectsSource audioObjectsSource) {
        registeredComponents.put(component, audioObjectsSource);
    }

    protected T preprocessObject(T t) {
        return t;
    }

    protected abstract void performAction(List<T> var1);

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        Component component = (Component)actionEvent.getSource();
        AudioObjectsSource audioObjectsSource = registeredComponents.get(component);
        if (audioObjectsSource == null) {
            return;
        }
        List<AudioObject> list = audioObjectsSource.getSelectedAudioObjects();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (AudioObject audioObject : list) {
            AudioObject audioObject2;
            if (!this.objectsClass.isAssignableFrom(audioObject.getClass()) || (audioObject2 = this.preprocessObject(audioObject)) == null) continue;
            arrayList.add(audioObject2);
        }
        this.performAction(arrayList);
    }

    @Override
    public boolean isEnabledForPlayListSelection(List<AudioObject> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (AudioObject audioObject : list) {
            if (audioObject.getClass().equals(this.objectsClass)) continue;
            return false;
        }
        return true;
    }
}

