/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.sourceforge.atunes.kernel.modules.context.AbstractContextPanel;
import net.sourceforge.atunes.kernel.modules.context.ContextHandler;

public final class ContextPanel
extends JPanel {
    private static final long serialVersionUID = 707242790413122482L;
    public static final Dimension PREF_SIZE = new Dimension(230, 0);
    public static final Dimension MINIMUM_SIZE = new Dimension(170, 0);
    private JTabbedPane tabbedPane;
    private Map<AbstractContextPanel, Integer> panelsIndexes = new HashMap<AbstractContextPanel, Integer>();

    public ContextPanel() {
        super(new BorderLayout());
        this.setPreferredSize(PREF_SIZE);
        this.setMinimumSize(MINIMUM_SIZE);
        this.setContent();
    }

    private void setContent() {
        this.tabbedPane = new JTabbedPane();
        this.add((Component)this.tabbedPane, "Center");
        for (AbstractContextPanel abstractContextPanel : ContextHandler.getInstance().getContextPanels()) {
            this.addContextPanel(abstractContextPanel);
        }
    }

    public void updateContextTabsText() {
        int n = 0;
        for (AbstractContextPanel abstractContextPanel : ContextHandler.getInstance().getContextPanels()) {
            this.tabbedPane.setTitleAt(n, abstractContextPanel.getTitle());
            ++n;
        }
    }

    public void updateContextTabsIcons() {
        int n = 0;
        for (AbstractContextPanel abstractContextPanel : ContextHandler.getInstance().getContextPanels()) {
            this.tabbedPane.setIconAt(n, abstractContextPanel.getIcon());
            ++n;
        }
    }

    public void enableContextTabs() {
        for (AbstractContextPanel abstractContextPanel : ContextHandler.getInstance().getContextPanels()) {
            this.enableContextTab(abstractContextPanel);
        }
    }

    private void enableContextTab(AbstractContextPanel abstractContextPanel) {
        this.tabbedPane.setEnabledAt(this.panelsIndexes.get(abstractContextPanel), abstractContextPanel.isEnabled());
        this.tabbedPane.getComponentAt(this.panelsIndexes.get(abstractContextPanel)).setEnabled(abstractContextPanel.isEnabled());
    }

    public void setSelectedIndex(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public int getSelectedIndex() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void addContextPanel(AbstractContextPanel abstractContextPanel) {
        this.tabbedPane.addTab(abstractContextPanel.getTitle(), abstractContextPanel.getIcon(), abstractContextPanel.getUIComponent());
        this.panelsIndexes.put(abstractContextPanel, this.tabbedPane.getTabCount() - 1);
        this.enableContextTab(abstractContextPanel);
    }

    public void removeContextPanel(AbstractContextPanel abstractContextPanel) {
        this.tabbedPane.remove(this.panelsIndexes.get(abstractContextPanel));
        this.panelsIndexes.remove(abstractContextPanel);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }
}

