/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.properties.PropertiesDialog;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

final class RadioPropertiesDialog
extends PropertiesDialog {
    private static final long serialVersionUID = -73744354419152730L;
    private JLabel pictureLabel;
    private JLabel titleLabel;
    private JLabel urlLabel;
    private JLabel labelLabel;
    private JLabel bitrateLabel;
    private JLabel frequencyLabel;
    private Radio radio;

    RadioPropertiesDialog(Radio radio, JFrame jFrame) {
        super(RadioPropertiesDialog.getTitleText(radio), jFrame);
        this.radio = radio;
        this.setAudioObject(radio);
        this.addContent();
        this.setContent();
        GuiUtils.applyComponentOrientation(this);
    }

    private static String getTitleText(Radio radio) {
        return StringUtils.getString(I18nUtils.getString("INFO_OF_RADIO"), " ", radio.getName());
    }

    private void addContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.pictureLabel = new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(40, 10, 5, 10);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 3;
        jPanel.add((Component)this.pictureLabel, gridBagConstraints);
        this.titleLabel = new JLabel();
        this.titleLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.titleLabel, gridBagConstraints);
        this.urlLabel = new JLabel();
        this.urlLabel.setFont(Fonts.getPropertiesDialogBigFont());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 10, 5, 10);
        jPanel.add((Component)this.urlLabel, gridBagConstraints);
        this.labelLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.labelLabel, gridBagConstraints);
        this.bitrateLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.bitrateLabel, gridBagConstraints);
        this.frequencyLabel = new JLabel();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)this.frequencyLabel, gridBagConstraints);
        this.add(jPanel);
    }

    private void fillPicture() {
        ImageIcon imageIcon = Images.getImage("radio.png");
        this.pictureLabel.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.pictureLabel.setIcon(imageIcon);
        this.pictureLabel.setVisible(true);
    }

    private void setContent() {
        this.fillPicture();
        this.titleLabel.setText(RadioPropertiesDialog.getHtmlFormatted(I18nUtils.getString("NAME"), StringUtils.isEmpty(this.radio.getName()) ? "-" : this.radio.getName()));
        this.urlLabel.setText(RadioPropertiesDialog.getHtmlFormatted(I18nUtils.getString("URL"), this.radio.getUrl()));
        this.labelLabel.setText(RadioPropertiesDialog.getHtmlFormatted(I18nUtils.getString("LABEL"), StringUtils.isEmpty(this.radio.getLabel()) ? "-" : this.radio.getLabel()));
        this.bitrateLabel.setText(RadioPropertiesDialog.getHtmlFormatted(I18nUtils.getString("BITRATE"), this.radio.getBitrate() > 0L ? StringUtils.getString(String.valueOf(this.radio.getBitrate()), " kbps") : "-"));
        this.frequencyLabel.setText(RadioPropertiesDialog.getHtmlFormatted(I18nUtils.getString("FREQUENCY"), this.radio.getFrequency() > 0 ? StringUtils.getString(String.valueOf(this.radio.getFrequency()), " Hz") : "-"));
    }
}

