/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.properties;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import net.sourceforge.atunes.gui.views.controls.CustomDialog;
import net.sourceforge.atunes.gui.views.dialogs.properties.AudioFilePropertiesDialog;
import net.sourceforge.atunes.gui.views.dialogs.properties.PodcastFeedEntryPropertiesDialog;
import net.sourceforge.atunes.gui.views.dialogs.properties.RadioPropertiesDialog;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.repository.data.AudioFile;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.StringUtils;

public class PropertiesDialog
extends CustomDialog {
    private static final long serialVersionUID = 6097305595858691246L;
    private static Map<AudioObject, PropertiesDialog> dialogsOpened;
    private AudioObject audioObject;

    PropertiesDialog(String string, JFrame jFrame) {
        super(jFrame, 560, 480);
        this.setMinimumSize(new Dimension(560, 480));
        this.setTitle(string);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.enableDisposeActionWithEscapeKey();
    }

    static String getHtmlFormatted(String string, String string2) {
        return StringUtils.getString("<html><b>", string, ": </b>", string2, "</html>");
    }

    @Override
    public void dispose() {
        PropertiesDialog.getDialogsOpened().remove(this.getAudioObject());
        if (!PropertiesDialog.getDialogsOpened().isEmpty()) {
            PropertiesDialog.getDialogsOpened().values().iterator().next().toFront();
        }
        super.dispose();
    }

    public static PropertiesDialog newInstance(AudioObject audioObject, JFrame jFrame) {
        if (PropertiesDialog.getDialogsOpened().containsKey(audioObject)) {
            return PropertiesDialog.getDialogsOpened().get(audioObject);
        }
        PropertiesDialog propertiesDialog = null;
        if (audioObject instanceof PodcastFeedEntry) {
            propertiesDialog = new PodcastFeedEntryPropertiesDialog((PodcastFeedEntry)audioObject, jFrame);
        } else if (audioObject instanceof Radio) {
            propertiesDialog = new RadioPropertiesDialog((Radio)audioObject, jFrame);
        } else if (audioObject instanceof AudioFile) {
            propertiesDialog = new AudioFilePropertiesDialog((AudioFile)audioObject, jFrame);
        }
        PropertiesDialog.getDialogsOpened().put(audioObject, propertiesDialog);
        return propertiesDialog;
    }

    private static Map<AudioObject, PropertiesDialog> getDialogsOpened() {
        if (dialogsOpened == null) {
            dialogsOpened = new HashMap<AudioObject, PropertiesDialog>();
        }
        return dialogsOpened;
    }

    protected AudioObject getAudioObject() {
        return this.audioObject;
    }

    protected void setAudioObject(AudioObject audioObject) {
        this.audioObject = audioObject;
    }
}

