/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.fullScreen;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomWindow;
import net.sourceforge.atunes.gui.views.controls.playerControls.MuteButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.NextButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.PlayPauseButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.PreviousButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.StopButton;
import net.sourceforge.atunes.gui.views.controls.playerControls.VolumeLevel;
import net.sourceforge.atunes.gui.views.controls.playerControls.VolumeSlider;
import net.sourceforge.atunes.gui.views.dialogs.fullScreen.CoverFlow;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.controllers.playerControls.ProgressBarSeekListener;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListEventListener;
import net.sourceforge.atunes.kernel.modules.playlist.PlayListHandler;
import net.sourceforge.atunes.kernel.modules.podcast.PodcastFeedEntry;
import net.sourceforge.atunes.kernel.modules.radio.Radio;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.model.AudioObject;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class FullScreenWindow
extends AbstractCustomWindow
implements PlayListEventListener {
    private static final long serialVersionUID = 3422799994808333945L;
    private CoverFlow covers;
    private JLabel textLabel;
    private JLabel textLabel2;
    private JSlider progressBar;
    private JLabel time;
    private JLabel remainingTime;
    private JPopupMenu options;
    private JMenuItem exitFullScreen;
    private JMenuItem selectBackground;
    private JMenuItem removeBackground;
    private PreviousButton previousButton;
    private PlayPauseButton playButton;
    private StopButton stopButton;
    private NextButton nextButton;
    private MuteButton muteButton;
    private VolumeSlider volumeSlider;
    private VolumeLevel volumeLevel;
    private JPanel textPanel;
    private JPanel controlsPanel;
    private boolean playing;
    private ImageIcon background;
    private KeyAdapter keyAdapter = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 122) {
                FullScreenWindow.this.setVisible(false);
            }
        }
    };
    private Timer hideMouseTimer;
    private MouseListener clickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            FullScreenWindow.this.activateTimer();
        }
    };
    private MouseMotionListener moveListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            FullScreenWindow.this.activateTimer();
        }
    };
    private MouseListener showMenuListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 3) {
                FullScreenWindow.this.options.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };
    private List<AudioObject> objects;

    public FullScreenWindow(JFrame jFrame) {
        super(jFrame, 0, 0);
        this.setLocation(0, 0);
        this.setAlwaysOnTop(true);
        this.setContent();
        this.addKeyListener(this.keyAdapter);
        File file = null;
        if (ApplicationState.getInstance().getFullScreenBackground() != null && !(file = new File(ApplicationState.getInstance().getFullScreenBackground())).exists()) {
            file = null;
        }
        if (file == null) {
            this.background = null;
        } else {
            this.setBackground(file);
        }
        GuiUtils.applyComponentOrientation(this);
        this.addMouseMotionListener(this.moveListener);
        this.addMouseListener(this.clickListener);
        PlayListHandler.getInstance().addPlayListEventListener(this);
    }

    void activateTimer() {
        this.setCursor(Cursor.getDefaultCursor());
        this.controlsPanel.setVisible(true);
        if (this.hideMouseTimer != null) {
            this.hideMouseTimer.restart();
        } else {
            this.hideMouseTimer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FullScreenWindow.this.controlsPanel.setVisible(false);
                    FullScreenWindow.this.setCursor(Toolkit.getDefaultToolkit().createCustomCursor(Images.getImage("empty.png").getImage(), new Point(0, 0), "invisibleCursor"));
                    if (FullScreenWindow.this.options.isVisible()) {
                        FullScreenWindow.this.options.setVisible(false);
                    }
                }
            });
        }
    }

    private int getInsetForProgressBar() {
        return GuiUtils.getDeviceWidth() / 4;
    }

    public JLabel getRemainingTime() {
        return this.remainingTime;
    }

    public JLabel getTime() {
        return this.time;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setAudioObjects(List<AudioObject> list) {
        if (list == null || list.isEmpty()) {
            this.textLabel.setText("");
            this.textLabel2.setText("");
            return;
        }
        this.objects = list;
        if (this.isVisible()) {
            this.updateWindow();
        }
    }

    private void setText(AudioObject audioObject) {
        if (audioObject == null) {
            this.textLabel.setText("");
            this.textLabel2.setText("");
        } else if (audioObject instanceof Radio) {
            this.progressBar.setEnabled(false);
            this.textLabel.setText(((Radio)audioObject).getName());
            this.textLabel2.setText(((Radio)audioObject).getUrl());
        } else if (audioObject instanceof PodcastFeedEntry) {
            this.progressBar.setEnabled(false);
            this.textLabel.setText(((PodcastFeedEntry)audioObject).getTitle());
            this.textLabel2.setText(((PodcastFeedEntry)audioObject).getPodcastFeed().getName());
        } else {
            this.textLabel.setText(audioObject.getTitleOrFileName());
            this.textLabel2.setText(audioObject.getArtist());
        }
    }

    void setBackground(File file) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        try {
            this.background = ImageUtils.scaleImageBicubic(ImageIO.read(file), dimension.width, dimension.height);
            ApplicationState.getInstance().setFullScreenBackground(file.getAbsolutePath());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void setContent() {
        JPanel jPanel = new JPanel(new BorderLayout()){
            private static final long serialVersionUID = 109708757849271173L;

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (FullScreenWindow.this.background == null) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, Color.BLACK, 0.0f, this.getHeight(), Color.BLACK));
                    graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                } else {
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    graphics.drawImage(ImageUtils.resize(FullScreenWindow.this.background, dimension.width, dimension.height).getImage(), 0, 0, this);
                }
            }
        };
        jPanel.setBackground(Color.black);
        this.add(jPanel);
        this.options = new JPopupMenu(I18nUtils.getString("OPTIONS"));
        this.options.addKeyListener(this.keyAdapter);
        this.options.addMouseListener(this.clickListener);
        jPanel.addMouseListener(this.showMenuListener);
        this.selectBackground = new JMenuItem(I18nUtils.getString("SELECT_BACKGROUND"));
        this.selectBackground.addActionListener(new SelectBackgroundActionListener());
        this.removeBackground = new JMenuItem(I18nUtils.getString("REMOVE_BACKGROUND"));
        this.removeBackground.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FullScreenWindow.this.background = null;
                ApplicationState.getInstance().setFullScreenBackground(null);
                FullScreenWindow.this.invalidate();
                FullScreenWindow.this.repaint();
            }
        });
        this.exitFullScreen = new JMenuItem(I18nUtils.getString("CLOSE"));
        this.exitFullScreen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FullScreenWindow.this.setVisible(false);
            }
        });
        this.options.add(this.selectBackground);
        this.options.add(this.removeBackground);
        this.options.add(this.exitFullScreen);
        this.previousButton = new PreviousButton(PlayerControlsPanel.PREVIOUS_NEXT_BUTTONS_SIZE);
        this.playButton = new PlayPauseButton(PlayerControlsPanel.PLAY_BUTTON_SIZE);
        this.stopButton = new StopButton(PlayerControlsPanel.STOP_MUTE_BUTTONS_SIZE);
        this.nextButton = new NextButton(PlayerControlsPanel.PREVIOUS_NEXT_BUTTONS_SIZE);
        this.muteButton = new MuteButton(PlayerControlsPanel.STOP_MUTE_BUTTONS_SIZE);
        this.muteButton.setText("");
        this.volumeSlider = new VolumeSlider();
        this.volumeLevel = new VolumeLevel();
        this.previousButton.addMouseListener(this.clickListener);
        this.playButton.addMouseListener(this.clickListener);
        this.stopButton.addMouseListener(this.clickListener);
        this.nextButton.addMouseListener(this.clickListener);
        this.muteButton.addMouseListener(this.clickListener);
        this.volumeSlider.addMouseListener(this.clickListener);
        this.volumeLevel.addMouseListener(this.clickListener);
        this.covers = new CoverFlow();
        Dimension dimension = new Dimension(GuiUtils.getDeviceWidth(), GuiUtils.getDeviceHeight() * 5 / 7);
        this.covers.setMinimumSize(dimension);
        this.covers.setMaximumSize(dimension);
        this.covers.setPreferredSize(dimension);
        this.covers.addMouseListener(this.clickListener);
        this.covers.addMouseListener(this.showMenuListener);
        this.covers.addMouseMotionListener(this.moveListener);
        this.textLabel = new JLabel();
        this.textLabel.setFont(Fonts.getFullScreenLine1Font());
        this.textLabel.setForeground(Color.WHITE);
        this.textLabel2 = new JLabel();
        this.textLabel2.setFont(Fonts.getContextInformationBigFont());
        this.textLabel2.setForeground(Color.WHITE);
        this.time = new JLabel("0:00");
        this.time.setFont(new Font("SansSerif", 0, 15));
        this.remainingTime = new JLabel("0:00");
        this.remainingTime.setFont(new Font("SansSerif", 0, 15));
        this.progressBar = new JSlider();
        this.progressBar.setOpaque(false);
        ProgressBarSeekListener progressBarSeekListener = new ProgressBarSeekListener(this.progressBar);
        this.progressBar.addMouseListener(progressBarSeekListener);
        this.progressBar.addKeyListener(this.keyAdapter);
        this.progressBar.setToolTipText(I18nUtils.getString("CLICK_TO_SEEK"));
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setFocusable(false);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.setOpaque(false);
        this.textPanel = new JPanel(new GridBagLayout());
        this.textPanel.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 20, 0);
        gridBagConstraints.anchor = 11;
        this.textPanel.add((Component)this.textLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.textPanel.add((Component)this.textLabel2, gridBagConstraints);
        jPanel2.add(this.textPanel);
        this.controlsPanel = new JPanel(new GridBagLayout());
        this.controlsPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        int n = this.getInsetForProgressBar();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, n, 0, 10);
        gridBagConstraints.gridwidth = 1;
        this.controlsPanel.add((Component)this.time, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.controlsPanel.add((Component)this.progressBar, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 10, 0, n);
        gridBagConstraints.weightx = 0.0;
        this.controlsPanel.add((Component)this.remainingTime, gridBagConstraints);
        JPanel jPanel3 = PlayerControlsPanel.getPanelWithPlayerControls(this.stopButton, this.previousButton, this.playButton, this.nextButton, this.muteButton, this.volumeSlider, this.volumeLevel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(20, 0, 5, 0);
        this.controlsPanel.add((Component)jPanel3, gridBagConstraints);
        jPanel2.add(this.controlsPanel);
        jPanel.add((Component)this.covers, "Center");
        jPanel.add((Component)jPanel2, "South");
    }

    private void setFullScreen(boolean bl) {
        if (SystemProperties.OS.isOldWindows() && !SystemProperties.OS.isWindowsVista()) {
            if (bl) {
                this.setSize(GuiUtils.getDeviceWidth(), GuiUtils.getDeviceHeight());
            }
        } else {
            GraphicsDevice graphicsDevice = GuiUtils.getGraphicsDeviceForLocation(GuiHandler.getInstance().getFrame().getLocation());
            graphicsDevice.setFullScreenWindow(bl ? this : null);
        }
    }

    public void setAudioObjectLength(long l) {
        this.progressBar.setMaximum((int)l);
    }

    public void setPlaying(boolean bl) {
        this.playing = bl;
        this.playButton.setPlaying(bl);
    }

    public void setCurrentAudioObjectPlayedTime(final long l, final long l2) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FullScreenWindow.this.setCurrentAudioObjectPlayedTimeEDT(l, l2);
                }
            });
        } else {
            this.setCurrentAudioObjectPlayedTimeEDT(l, l2);
        }
    }

    private void setCurrentAudioObjectPlayedTimeEDT(long l, long l2) {
        long l3 = l2 - l;
        if (l == 0L) {
            this.remainingTime.setText(StringUtils.milliseconds2String(l));
        } else {
            this.remainingTime.setText(l3 > 0L ? StringUtils.getString("- ", StringUtils.milliseconds2String(l3)) : "-");
        }
        this.time.setText(StringUtils.milliseconds2String(l));
        this.progressBar.setValue((int)l);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateWindow();
            this.activateTimer();
        }
        this.setFullScreen(bl);
    }

    public void setVolume(int n) {
        this.volumeSlider.setValue(n);
        this.volumeLevel.setText(StringUtils.getString(String.valueOf(n), " %"));
    }

    private void updateWindow() {
        this.setText(this.objects.get(2));
        this.covers.paint(this.objects);
    }

    @Override
    public void clear() {
        if (ApplicationState.getInstance().isStopPlayerOnPlayListClear()) {
            this.setAudioObjects(null);
        }
    }

    @Override
    public void selectedAudioObjectChanged(AudioObject audioObject) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        arrayList.add(PlayListHandler.getInstance().getCurrentPlayList(false).getPreviousAudioObject(2));
        arrayList.add(PlayListHandler.getInstance().getCurrentPlayList(false).getPreviousAudioObject(1));
        arrayList.add(audioObject);
        arrayList.add(PlayListHandler.getInstance().getCurrentPlayList(false).getNextAudioObject(1));
        arrayList.add(PlayListHandler.getInstance().getCurrentPlayList(false).getNextAudioObject(2));
        this.setAudioObjects(arrayList);
    }

    private final class SelectBackgroundActionListener
    implements ActionListener {
        private SelectBackgroundActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FullScreenWindow.this.setVisible(false);
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = file.getName().toUpperCase();
                    return string.endsWith("JPG") || string.endsWith("JPEG") || string.endsWith("PNG");
                }

                @Override
                public String getDescription() {
                    return I18nUtils.getString("IMAGES");
                }
            });
            if (jFileChooser.showOpenDialog(FullScreenWindow.this) == 0) {
                File file = jFileChooser.getSelectedFile();
                FullScreenWindow.this.setBackground(file);
                FullScreenWindow.this.invalidate();
                FullScreenWindow.this.repaint();
            }
        }
    }
}

