/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.atunes.gui.ColorDefinitions;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractTableCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.hotkeys.Hotkey;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeyHandler;
import net.sourceforge.atunes.kernel.modules.hotkeys.HotkeysConfig;
import net.sourceforge.atunes.kernel.modules.player.PlayerHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class PlayerPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 4489293347321979288L;
    private JCheckBox playAtStartup;
    private JCheckBox showTicks;
    private JCheckBox useFadeAway;
    private JCheckBox useShortPathNames;
    private JCheckBox enableGlobalHotkeys;
    private JTable hotkeyTable;
    private HotkeyTableModel tableModel = new HotkeyTableModel();
    private Set<Integer> conflicts = new HashSet<Integer>();
    private Set<Integer> notRecommendedKeys = new HashSet<Integer>();
    private JButton resetHotkeys;
    private JCheckBox cacheFilesBeforePlaying;
    private JComboBox engineCombo;

    public PlayerPanel() {
        super(I18nUtils.getString("PLAYER"));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.0f);
        box.add(new JLabel(I18nUtils.getString("PLAYER_ENGINE")));
        box.add(Box.createHorizontalStrut(6));
        this.engineCombo = new JComboBox<String>(PlayerHandler.getInstance().getEngineNames());
        box.add(this.engineCombo);
        box.add(Box.createHorizontalGlue());
        this.playAtStartup = new JCheckBox(I18nUtils.getString("PLAY_AT_STARTUP"));
        this.useFadeAway = new JCheckBox(I18nUtils.getString("USE_FADE_AWAY"));
        this.showTicks = new JCheckBox(I18nUtils.getString("SHOW_TICKS"));
        this.useShortPathNames = new JCheckBox(I18nUtils.getString("USE_SHORT_PATH_NAMES_FOR_MPLAYER"));
        this.enableGlobalHotkeys = new JCheckBox(I18nUtils.getString("ENABLE_GLOBAL_HOTKEYS"));
        this.hotkeyTable = new JTable();
        this.hotkeyTable.setModel(this.tableModel);
        this.hotkeyTable.getTableHeader().setReorderingAllowed(false);
        this.hotkeyTable.getTableHeader().setResizingAllowed(false);
        this.hotkeyTable.getSelectionModel().setSelectionMode(0);
        this.hotkeyTable.setEnabled(HotkeyHandler.getInstance().areHotkeysSupported());
        this.hotkeyTable.setDefaultRenderer(Object.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(new HotkeyTableTableCellRendererCode()));
        this.hotkeyTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n = PlayerPanel.this.hotkeyTable.getSelectedRow();
                int n2 = keyEvent.getModifiersEx();
                int n3 = keyEvent.getKeyCode();
                if (n != -1 && n3 != 0 && (n2 & 0x400) == 0 && (n2 & 0x800) == 0 && (n2 & 0x1000) == 0) {
                    Hotkey hotkey = PlayerPanel.this.tableModel.getHotkeysConfig().getHotkeyByOrder(n);
                    hotkey.setMod(n2);
                    hotkey.setKey(n3);
                    PlayerPanel.this.conflicts = PlayerPanel.this.tableModel.getHotkeysConfig().conflicts();
                    PlayerPanel.this.notRecommendedKeys = PlayerPanel.this.tableModel.getHotkeysConfig().notRecommendedKeys();
                    PlayerPanel.this.tableModel.fireTableRowsUpdated(0, PlayerPanel.this.tableModel.getRowCount());
                }
            }
        });
        InputMap inputMap = this.hotkeyTable.getInputMap(1);
        for (KeyStroke keyStroke : inputMap.allKeys()) {
            inputMap.put(keyStroke, "none");
        }
        this.resetHotkeys = new JButton(I18nUtils.getString("RESET"));
        this.resetHotkeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlayerPanel.this.tableModel.setHotkeysConfig(HotkeyHandler.getInstance().getDefaultHotkeysConfiguration());
                PlayerPanel.this.tableModel.fireTableDataChanged();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.hotkeyTable);
        jScrollPane.setMinimumSize(new Dimension(400, 200));
        this.cacheFilesBeforePlaying = new JCheckBox(I18nUtils.getString("CACHE_FILES_BEFORE_PLAYING"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 23;
        Insets insets = gridBagConstraints.insets;
        gridBagConstraints.insets = new Insets(0, 8, 0, 0);
        this.add((Component)box, gridBagConstraints);
        gridBagConstraints.insets = insets;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.playAtStartup, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.useFadeAway, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.add((Component)this.showTicks, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.add((Component)this.useShortPathNames, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.add((Component)this.cacheFilesBeforePlaying, gridBagConstraints);
        gridBagConstraints.gridy = 6;
        this.add((Component)this.enableGlobalHotkeys, gridBagConstraints);
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 20, 5, 10);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 10;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.add((Component)this.resetHotkeys, gridBagConstraints);
    }

    public JCheckBox getEnableGlobalHotkeys() {
        return this.enableGlobalHotkeys;
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        boolean bl = false;
        applicationState.setPlayAtStartup(this.playAtStartup.isSelected());
        applicationState.setUseFadeAway(this.useFadeAway.isSelected());
        applicationState.setShowTicks(this.showTicks.isSelected());
        applicationState.setUseShortPathNames(this.useShortPathNames.isSelected());
        applicationState.setEnableHotkeys(this.enableGlobalHotkeys.isSelected());
        applicationState.setHotkeysConfig(this.tableModel.getHotkeysConfig());
        applicationState.setCacheFilesBeforePlaying(this.cacheFilesBeforePlaying.isSelected());
        String string = this.engineCombo.getSelectedItem().toString();
        if (!applicationState.getPlayerEngine().equals(string)) {
            applicationState.setPlayerEngine(string);
            bl = true;
        }
        return bl;
    }

    private JCheckBox getUseShortPathNames() {
        return this.useShortPathNames;
    }

    private void setEnableHotkeys(boolean bl) {
        this.enableGlobalHotkeys.setSelected(bl);
    }

    private void setPlayAtStartup(boolean bl) {
        this.playAtStartup.setSelected(bl);
    }

    private void setUseShortPathNames(boolean bl) {
        this.useShortPathNames.setSelected(bl);
    }

    private void setUseFadeAway(boolean bl) {
        this.useFadeAway.setSelected(bl);
    }

    private void setShowTicks(boolean bl) {
        this.showTicks.setSelected(bl);
    }

    private void setCacheFilesBeforePlaying(boolean bl) {
        this.cacheFilesBeforePlaying.setSelected(bl);
    }

    private void setHotkeysConfig(HotkeysConfig hotkeysConfig) {
        this.tableModel.setHotkeysConfig(hotkeysConfig);
    }

    private void setPlayerEngine(String string) {
        this.engineCombo.setSelectedItem(string);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setPlayerEngine(applicationState.getPlayerEngine());
        this.setPlayAtStartup(applicationState.isPlayAtStartup());
        this.setUseFadeAway(applicationState.isUseFadeAway());
        this.setShowTicks(applicationState.isShowTicks());
        this.setCacheFilesBeforePlaying(applicationState.isCacheFilesBeforePlaying());
        this.setEnableHotkeys(applicationState.isEnableHotkeys());
        HotkeysConfig hotkeysConfig = applicationState.getHotkeysConfig();
        this.setHotkeysConfig(hotkeysConfig != null ? hotkeysConfig : HotkeyHandler.getInstance().getHotkeysConfig());
        this.setUseShortPathNames(applicationState.isUseShortPathNames());
        this.getUseShortPathNames().setEnabled(SystemProperties.OS == SystemProperties.OperatingSystem.WINDOWS);
        this.getEnableGlobalHotkeys().setEnabled(HotkeyHandler.getInstance().areHotkeysSupported());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
        if (bl) {
            HotkeyHandler.getInstance().disableHotkeys();
        } else if (ApplicationState.getInstance().isEnableHotkeys()) {
            HotkeyHandler.getInstance().enableHotkeys(ApplicationState.getInstance().getHotkeysConfig());
        }
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("playTiny.png");
    }

    class HotkeyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5726677745418003289L;
        private HotkeysConfig hotkeysConfig;

        HotkeyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? I18nUtils.getString("ACTION") : I18nUtils.getString("HOTKEY");
        }

        @Override
        public int getRowCount() {
            return this.hotkeysConfig != null ? this.hotkeysConfig.size() : 0;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.hotkeysConfig != null) {
                if (n2 == 0) {
                    return this.hotkeysConfig.getHotkeyByOrder(n).getDescription();
                }
                if (n2 == 1) {
                    return this.hotkeysConfig.getHotkeyByOrder(n).getKeyDescription();
                }
            }
            return "";
        }

        public void setHotkeysConfig(HotkeysConfig hotkeysConfig) {
            this.hotkeysConfig = hotkeysConfig;
            PlayerPanel.this.conflicts = hotkeysConfig.conflicts();
            PlayerPanel.this.notRecommendedKeys = hotkeysConfig.notRecommendedKeys();
            this.fireTableDataChanged();
        }

        public HotkeysConfig getHotkeysConfig() {
            return this.hotkeysConfig;
        }
    }

    private final class HotkeyTableTableCellRendererCode
    extends AbstractTableCellRendererCode {
        private HotkeyTableTableCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component2 = component;
            GuiUtils.applyComponentOrientation((JLabel)component2);
            if (PlayerPanel.this.conflicts.contains(n) || PlayerPanel.this.notRecommendedKeys.contains(n)) {
                ((JLabel)component2).setForeground(ColorDefinitions.WARNING_COLOR);
            }
            String string = "";
            if (PlayerPanel.this.conflicts.contains(n)) {
                string = string + I18nUtils.getString("DUPLICATE_HOTKEYS");
            }
            if (PlayerPanel.this.notRecommendedKeys.contains(n)) {
                if (PlayerPanel.this.conflicts.contains(n)) {
                    string = string + " ";
                }
                string = string + I18nUtils.getString("NOT_RECOMMENDED_HOTKEYS");
            }
            ((JLabel)component2).setToolTipText(string.isEmpty() ? null : string);
            return component2;
        }
    }
}

