/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.utils.I18nUtils;

public final class OSDPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = 4489293347321979288L;
    private JComboBox osdDuration;
    private JComboBox osdWidth;
    private JComboBox osdHorizontalAlignment;
    private JComboBox osdVerticalAlignment;
    private JCheckBox useLibnotify;
    private static final String LEFT = I18nUtils.getString("LEFT");
    private static final String CENTER = I18nUtils.getString("CENTER");
    private static final String RIGHT = I18nUtils.getString("RIGHT");
    private static final String TOP = I18nUtils.getString("TOP");
    private static final String BOTTOM = I18nUtils.getString("BOTTOM");

    public OSDPanel() {
        super(I18nUtils.getString("OSD"));
        JLabel jLabel = new JLabel(I18nUtils.getString("OSD_DURATION"));
        this.osdDuration = new JComboBox<Integer>(new Integer[]{2, 4, 6});
        JLabel jLabel2 = new JLabel(I18nUtils.getString("OSD_WIDTH"));
        this.osdWidth = new JComboBox<Integer>(new Integer[]{400, 500, 600});
        JLabel jLabel3 = new JLabel(I18nUtils.getString("HORIZONTAL_ALIGNMENT"));
        this.osdHorizontalAlignment = new JComboBox<String>(new String[]{LEFT, CENTER, RIGHT});
        JLabel jLabel4 = new JLabel(I18nUtils.getString("VERTICAL_ALIGNMENT"));
        this.osdVerticalAlignment = new JComboBox<String>(new String[]{TOP, CENTER, BOTTOM});
        JLabel jLabel5 = new JLabel(I18nUtils.getString("USE_LIBNOTIFY"));
        this.useLibnotify = new JCheckBox();
        this.useLibnotify.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                OSDPanel.this.osdDuration.setEnabled(!OSDPanel.this.useLibnotify.isSelected());
                OSDPanel.this.osdWidth.setEnabled(!OSDPanel.this.useLibnotify.isSelected());
                OSDPanel.this.osdHorizontalAlignment.setEnabled(!OSDPanel.this.useLibnotify.isSelected());
                OSDPanel.this.osdVerticalAlignment.setEnabled(!OSDPanel.this.useLibnotify.isSelected());
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.osdDuration, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.osdWidth, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.osdHorizontalAlignment, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.add((Component)this.osdVerticalAlignment, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(20, 10, 0, 0);
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.useLibnotify, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        applicationState.setOsdDuration((Integer)this.osdDuration.getSelectedItem());
        applicationState.setOsdWidth((Integer)this.osdWidth.getSelectedItem());
        applicationState.setOsdHorizontalAlignment(this.getAlignment((String)this.osdHorizontalAlignment.getSelectedItem()));
        applicationState.setOsdVerticalAlignment(this.getAlignment((String)this.osdVerticalAlignment.getSelectedItem()));
        applicationState.setUseLibnotify(this.useLibnotify.isSelected());
        return false;
    }

    private void setOSDDuration(int n) {
        this.osdDuration.setSelectedItem(n);
    }

    private void setOSDWidth(int n) {
        this.osdWidth.setSelectedItem(n);
    }

    private void setOSDHorizontalAlignment(int n) {
        if (n == 2) {
            this.osdHorizontalAlignment.setSelectedItem(LEFT);
        } else if (n == 0) {
            this.osdHorizontalAlignment.setSelectedItem(CENTER);
        } else if (n == 4) {
            this.osdHorizontalAlignment.setSelectedItem(RIGHT);
        }
    }

    private int getAlignment(String string) {
        if (LEFT.equals(string)) {
            return 2;
        }
        if (RIGHT.equals(string)) {
            return 4;
        }
        if (TOP.equals(string)) {
            return 1;
        }
        if (BOTTOM.equals(string)) {
            return 3;
        }
        if (CENTER.equals(string)) {
            return 0;
        }
        return 0;
    }

    private void setOSDVerticalAlignment(int n) {
        if (n == 1) {
            this.osdVerticalAlignment.setSelectedItem(TOP);
        } else if (n == 0) {
            this.osdVerticalAlignment.setSelectedItem(CENTER);
        } else if (n == 3) {
            this.osdVerticalAlignment.setSelectedItem(BOTTOM);
        }
    }

    public void setUseLibnotify(boolean bl) {
        this.useLibnotify.setSelected(bl);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.setOSDDuration(applicationState.getOsdDuration());
        this.setOSDWidth(applicationState.getOsdWidth());
        this.setOSDHorizontalAlignment(applicationState.getOsdHorizontalAlignment());
        this.setOSDVerticalAlignment(applicationState.getOsdVerticalAlignment());
        this.setUseLibnotify(applicationState.isUseLibnotify());
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("osd.png");
    }
}

