/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs.editPreferences;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.frame.Frame;
import net.sourceforge.atunes.gui.frame.Frames;
import net.sourceforge.atunes.gui.images.Images;
import net.sourceforge.atunes.gui.lookandfeel.AbstractListCellRendererCode;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelBean;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.ByImageChoosingPanel;
import net.sourceforge.atunes.gui.views.dialogs.FontChooserDialog;
import net.sourceforge.atunes.gui.views.dialogs.editPreferences.AbstractPreferencesPanel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.LocaleBean;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;
import org.jdesktop.swingx.combobox.ListComboBoxModel;

public final class GeneralPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -9216216930198145476L;
    private JCheckBox showTitle = new JCheckBox(I18nUtils.getString("SHOW_TITLE"));
    private JComboBox language;
    private JCheckBox showIconTray;
    private JCheckBox showTrayPlayer;
    private JButton fontSettings;
    private JComboBox lookAndFeel;
    private JLabel skinLabel;
    private JComboBox skin;
    private ByImageChoosingPanel<Class<? extends Frame>> windowTypeChoosingPanel;
    private ActionListener applySkinActionListener;
    private FontChooserDialog.FontSettings currentFontSettings;

    public GeneralPanel() {
        super(I18nUtils.getString("GENERAL"));
        JLabel jLabel = new JLabel(I18nUtils.getString("WINDOW_TYPE"));
        jLabel.setFont(Fonts.getGeneralBoldFont());
        JLabel jLabel2 = new JLabel(I18nUtils.getString("LANGUAGE"));
        jLabel2.setFont(Fonts.getGeneralBoldFont());
        List<Locale> list = I18nUtils.getLanguages();
        Locale[] localeArray = list.toArray(new Locale[list.size()]);
        Locale locale = ApplicationState.getInstance().getLocale().getLocale();
        Arrays.sort(localeArray, new LocaleComparator(locale));
        this.language = new JComboBox<Locale>(localeArray);
        this.language.setRenderer(LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getListCellRenderer(new LanguageListCellRendererCode()));
        this.showIconTray = new JCheckBox(I18nUtils.getString("SHOW_TRAY_ICON"));
        this.showTrayPlayer = new JCheckBox(I18nUtils.getString("SHOW_TRAY_PLAYER"));
        JLabel jLabel3 = new JLabel(I18nUtils.getString("LOOK_AND_FEEL"));
        jLabel3.setFont(Fonts.getGeneralBoldFont());
        this.skinLabel = new JLabel(I18nUtils.getString("THEME"));
        this.skinLabel.setFont(Fonts.getGeneralBoldFont());
        this.fontSettings = new JButton(I18nUtils.getString("CHANGE_FONT_SETTINGS"));
        this.fontSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooserDialog fontChooserDialog = GeneralPanel.this.currentFontSettings != null ? new FontChooserDialog(GuiHandler.getInstance().getFrame().getFrame(), 300, 300, GeneralPanel.this.currentFontSettings.getFont().toFont(), GeneralPanel.this.currentFontSettings.isUseFontSmoothing(), GeneralPanel.this.currentFontSettings.isUseFontSmoothingSettingsFromOs(), ApplicationState.getInstance().getLocale().getLocale()) : new FontChooserDialog(GuiHandler.getInstance().getFrame().getFrame(), 300, 300, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getDefaultFont(), true, false, ApplicationState.getInstance().getLocale().getLocale());
                fontChooserDialog.setVisible(true);
                if (fontChooserDialog.getSelectedFontSettings() != null) {
                    GeneralPanel.this.currentFontSettings = fontChooserDialog.getSelectedFontSettings();
                }
            }
        });
        this.lookAndFeel = new JComboBox();
        this.lookAndFeel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = LookAndFeelSelector.getInstance().getCurrentLookAndFeelName().equals(GeneralPanel.this.lookAndFeel.getSelectedItem());
                GeneralPanel.this.skinLabel.setEnabled(bl);
                GeneralPanel.this.skin.setEnabled(bl);
                GeneralPanel.this.skin.setModel(bl ? new ListComboBoxModel(LookAndFeelSelector.getInstance().getAvailableSkins((String)GeneralPanel.this.lookAndFeel.getSelectedItem())) : new ListComboBoxModel(new ArrayList()));
            }
        });
        this.skin = new JComboBox();
        ArrayList<ByImageChoosingPanel.ImageEntry<Class<? extends Frame>>> arrayList = new ArrayList<ByImageChoosingPanel.ImageEntry<Class<? extends Frame>>>();
        for (Class<? extends Frame> serializable2 : Frames.getClasses()) {
            arrayList.add(new ByImageChoosingPanel.ImageEntry<Class<? extends Frame>>(serializable2, Frames.getImage(serializable2)));
        }
        this.windowTypeChoosingPanel = new ByImageChoosingPanel(arrayList);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)this.language, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(25, 0, 5, 0);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        this.add((Component)this.lookAndFeel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(25, 0, 5, 0);
        this.add((Component)this.skinLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(25, 0, 0, 0);
        this.add((Component)this.skin, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(20, 0, 0, 0);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.windowTypeChoosingPanel);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(20, 0, 20, 0);
        this.add((Component)this.fontSettings, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.showTitle, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.showTrayPlayer, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.showIconTray, gridBagConstraints);
    }

    @Override
    public boolean applyPreferences(ApplicationState applicationState) {
        boolean bl = false;
        applicationState.setShowTitle(this.showTitle.isSelected());
        Class<? extends Frame> clazz = applicationState.getFrameClass();
        Class<? extends Frame> clazz2 = this.windowTypeChoosingPanel.getSelectedItem();
        applicationState.setFrameClass(clazz2);
        if (!clazz.equals(clazz2)) {
            bl = true;
        }
        LocaleBean localeBean = applicationState.getLocale();
        LocaleBean localeBean2 = new LocaleBean((Locale)this.language.getSelectedItem());
        applicationState.setLocale(localeBean2);
        if (!localeBean.equals(localeBean2)) {
            bl = true;
            applicationState.setOldLocale(new LocaleBean(Locale.getDefault()));
        }
        FontChooserDialog.FontSettings fontSettings = applicationState.getFontSettings();
        applicationState.setFontSettings(this.currentFontSettings);
        if (!fontSettings.equals(this.currentFontSettings)) {
            bl = true;
        }
        applicationState.setShowSystemTray(this.showIconTray.isSelected());
        applicationState.setShowTrayPlayer(this.showTrayPlayer.isSelected());
        LookAndFeelBean lookAndFeelBean = applicationState.getLookAndFeel();
        LookAndFeelBean lookAndFeelBean2 = new LookAndFeelBean();
        lookAndFeelBean2.setName((String)this.lookAndFeel.getSelectedItem());
        lookAndFeelBean2.setSkin((String)this.skin.getSelectedItem());
        applicationState.setLookAndFeel(lookAndFeelBean2);
        if (!lookAndFeelBean.getName().equals(lookAndFeelBean2.getName())) {
            bl = true;
        }
        return bl;
    }

    private void setLanguage(Locale locale) {
        this.language.setSelectedItem(locale);
    }

    private void setShowIconTray(boolean bl) {
        this.showIconTray.setSelected(bl);
    }

    private void setShowTitle(boolean bl) {
        this.showTitle.setSelected(bl);
    }

    private void setShowTrayPlayer(boolean bl) {
        this.showTrayPlayer.setSelected(bl);
    }

    private void setLookAndFeel(String string) {
        this.lookAndFeel.setSelectedItem(string);
    }

    private void setSkin(String string) {
        if (this.applySkinActionListener != null) {
            this.skin.removeActionListener(this.applySkinActionListener);
        }
        this.skin.setSelectedItem(string);
        if (this.applySkinActionListener == null) {
            this.applySkinActionListener = new ApplySkinActionListener();
        }
        this.skin.addActionListener(this.applySkinActionListener);
    }

    private void setWindowType(Class<? extends Frame> clazz) {
        this.windowTypeChoosingPanel.setSelectedItem(clazz);
    }

    @Override
    public void updatePanel(ApplicationState applicationState) {
        this.lookAndFeel.setModel(new ListComboBoxModel(LookAndFeelSelector.getInstance().getAvailableLookAndFeels()));
        this.setShowTitle(applicationState.isShowTitle());
        this.setWindowType(applicationState.getFrameClass());
        this.setLanguage(I18nUtils.getSelectedLocale());
        this.setShowIconTray(applicationState.isShowSystemTray());
        this.setShowTrayPlayer(applicationState.isShowTrayPlayer());
        String string = LookAndFeelSelector.getInstance().getAvailableLookAndFeels().contains(applicationState.getLookAndFeel().getName()) ? applicationState.getLookAndFeel().getName() : LookAndFeelSelector.getDefaultLookAndFeel().getName();
        this.setLookAndFeel(string);
        this.updateSkins(string);
        this.setSkin(applicationState.getLookAndFeel().getSkin() != null ? applicationState.getLookAndFeel().getSkin() : LookAndFeelSelector.getInstance().getDefaultSkin(string));
        this.currentFontSettings = applicationState.getFontSettings();
    }

    @Override
    public void resetImmediateChanges(ApplicationState applicationState) {
        if (applicationState.getLookAndFeel().getSkin() == null || !applicationState.getLookAndFeel().getSkin().equals(this.skin.getSelectedItem())) {
            LookAndFeelSelector.getInstance().applySkin(applicationState.getLookAndFeel().getSkin());
        }
    }

    @Override
    public boolean validatePanel() {
        return true;
    }

    @Override
    public void dialogVisibilityChanged(boolean bl) {
    }

    @Override
    public ImageIcon getIcon() {
        return Images.getImage("prefs.png");
    }

    protected void updateSkins(String string) {
        boolean bl = !LookAndFeelSelector.getInstance().getAvailableSkins(string).isEmpty();
        this.skinLabel.setEnabled(bl);
        this.skin.setEnabled(bl);
        if (this.applySkinActionListener != null) {
            this.skin.removeActionListener(this.applySkinActionListener);
        }
        this.skin.setModel(new ListComboBoxModel(LookAndFeelSelector.getInstance().getAvailableSkins(string)));
        this.skin.setSelectedItem(LookAndFeelSelector.getInstance().getDefaultSkin(string));
        if (this.applySkinActionListener == null) {
            this.applySkinActionListener = new ApplySkinActionListener();
        }
        this.skin.addActionListener(this.applySkinActionListener);
    }

    private class ApplySkinActionListener
    implements ActionListener {
        private ApplySkinActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)GeneralPanel.this.skin.getSelectedItem();
            boolean bl = LookAndFeelSelector.getInstance().getCurrentLookAndFeelName().equals(GeneralPanel.this.lookAndFeel.getSelectedItem());
            if (bl) {
                LookAndFeelSelector.getInstance().applySkin(string);
            }
        }
    }

    private static final class LocaleComparator
    implements Comparator<Locale> {
        private final Locale currentLocale;

        private LocaleComparator(Locale locale) {
            this.currentLocale = locale;
        }

        @Override
        public int compare(Locale locale, Locale locale2) {
            return Collator.getInstance().compare(locale.getDisplayName(this.currentLocale), locale2.getDisplayName(this.currentLocale));
        }
    }

    private static class LanguageListCellRendererCode
    extends AbstractListCellRendererCode {
        private LanguageListCellRendererCode() {
        }

        @Override
        public Component getComponent(Component component, JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (!(object instanceof Locale)) {
                throw new IllegalArgumentException("Argument value must be instance of Locale");
            }
            Component component2 = component;
            Locale locale = (Locale)object;
            Locale locale2 = ApplicationState.getInstance().getLocale().getLocale();
            String string = locale.getDisplayName(locale2);
            string = StringUtils.getString(String.valueOf(string.charAt(0)).toUpperCase(locale2), string.substring(1));
            ((JLabel)component2).setText(string);
            String string2 = StringUtils.getString("flag_", locale.toString(), ".png");
            URL uRL = GeneralPanel.class.getResource(StringUtils.getString("/", "translations", "/", string2));
            if (uRL != null) {
                ((JLabel)component2).setIcon(new ImageIcon(uRL));
            }
            return component2;
        }
    }
}

