/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomModalDialog;
import net.sourceforge.atunes.gui.views.controls.CustomButton;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.kernel.controllers.ripcd.RipCdDialogController;
import net.sourceforge.atunes.kernel.modules.cdripper.cdda2wav.model.CDInfo;
import net.sourceforge.atunes.kernel.modules.repository.data.Artist;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;
import net.sourceforge.atunes.utils.StringUtils;

public final class RipCdDialog
extends AbstractCustomModalDialog {
    private static final long serialVersionUID = 1987727841297807350L;
    private JTable table;
    private JTextField artistTextField;
    private JTextField albumTextField;
    private JTextField yearTextField;
    private JComboBox genreComboBox;
    private JButton titlesButton;
    private JComboBox format;
    private JComboBox quality;
    private JComboBox filePattern;
    private JTextField folderName;
    private JButton folderSelectionButton;
    private JCheckBox useCdErrorCorrection;
    private JButton ok;
    private JButton cancel;
    private CdInfoTableModel tableModel;

    public RipCdDialog(JFrame jFrame) {
        super((Window)jFrame, 750, 540, true);
        this.setTitle(I18nUtils.getString("RIP_CD"));
        this.setContent(this.getContent());
        GuiUtils.applyComponentOrientation(this);
        this.enableCloseActionWithEscapeKey();
    }

    public static void main(String[] stringArray) {
        RipCdDialog ripCdDialog = new RipCdDialog(null);
        ripCdDialog.setVisible(true);
    }

    public JTextField getAlbumTextField() {
        return this.albumTextField;
    }

    public JButton getTitlesButton() {
        return this.titlesButton;
    }

    public List<String> getArtistNames() {
        return this.tableModel.artistNames;
    }

    public JTextField getArtistTextField() {
        return this.artistTextField;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public List<String> getComposerNames() {
        return this.tableModel.composerNames;
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.tableModel = new CdInfoTableModel();
        this.table = new JTable(this.tableModel);
        this.table.setShowGrid(false);
        this.table.getColumnModel().getColumn(0).setMaxWidth(20);
        this.table.getColumnModel().getColumn(4).setMaxWidth(50);
        JCheckBox jCheckBox = new JCheckBox();
        this.table.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(jCheckBox));
        CustomTextField customTextField = new CustomTextField();
        CustomTextField customTextField2 = new CustomTextField();
        CustomTextField customTextField3 = new CustomTextField();
        customTextField.setBorder(BorderFactory.createEmptyBorder());
        customTextField2.setBorder(BorderFactory.createEmptyBorder());
        customTextField3.setBorder(BorderFactory.createEmptyBorder());
        GuiUtils.applyComponentOrientation(customTextField);
        GuiUtils.applyComponentOrientation(customTextField2);
        GuiUtils.applyComponentOrientation(customTextField3);
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(customTextField));
        this.table.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(customTextField2));
        this.table.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(customTextField3));
        this.table.setDefaultRenderer(String.class, LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getTableCellRenderer(GuiUtils.getComponentOrientationTableCellRendererCode()));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        JLabel jLabel = new JLabel(I18nUtils.getString("ALBUM_ARTIST"));
        this.artistTextField = new CustomTextField();
        JLabel jLabel2 = new JLabel(I18nUtils.getString("ALBUM"));
        this.albumTextField = new CustomTextField();
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(I18nUtils.getString("YEAR"));
        this.yearTextField = new CustomTextField();
        JLabel jLabel4 = new JLabel(I18nUtils.getString("GENRE"));
        this.genreComboBox = new JComboBox();
        this.genreComboBox.setEditable(true);
        this.titlesButton = new CustomButton(null, I18nUtils.getString("GET_TITLES"));
        JLabel jLabel5 = new JLabel(I18nUtils.getString("ENCODE_TO"));
        this.format = new JComboBox();
        JLabel jLabel6 = new JLabel(I18nUtils.getString("QUALITY"));
        this.quality = new JComboBox<String>(new String[0]);
        this.quality.setMinimumSize(new Dimension(150, 20));
        JLabel jLabel7 = new JLabel(I18nUtils.getString("FILEPATTERN"));
        this.filePattern = new JComboBox<String>(RipCdDialogController.FILENAMEPATTERN);
        JLabel jLabel8 = new JLabel(I18nUtils.getString("FOLDER"));
        this.folderName = new CustomTextField();
        this.folderSelectionButton = new JButton(I18nUtils.getString("SELECT_FOLDER"));
        JLabel jLabel9 = new JLabel(StringUtils.getString("%A=", I18nUtils.getString("ARTIST"), "  -  %L=", I18nUtils.getString("ALBUM"), "  -  %N=", I18nUtils.getString("TRACK"), "  -  %T=", I18nUtils.getString("TITLE")));
        this.useCdErrorCorrection = new JCheckBox(I18nUtils.getString("USE_CD_ERROR_CORRECTION"));
        this.ok = new CustomButton(null, I18nUtils.getString("OK"));
        this.cancel = new CustomButton(null, I18nUtils.getString("CANCEL"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.add(this.ok);
        jPanel2.add(this.cancel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(20, 20, 10, 20);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 5, 20);
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.artistTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.albumTextField, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.genreComboBox, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.yearTextField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)this.titlesButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.format, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jLabel6, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.quality, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.useCdErrorCorrection, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel8, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)this.folderName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)jLabel7, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.filePattern, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.folderSelectionButton, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jLabel9, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public String getFileNamePattern() {
        return (String)this.filePattern.getSelectedItem();
    }

    public JComboBox getFilePattern() {
        return this.filePattern;
    }

    public JTextField getFolderName() {
        return this.folderName;
    }

    public JButton getFolderSelectionButton() {
        return this.folderSelectionButton;
    }

    public JComboBox getFormat() {
        return this.format;
    }

    public JComboBox getGenreComboBox() {
        return this.genreComboBox;
    }

    public JButton getOk() {
        return this.ok;
    }

    public String getQuality() {
        return (String)this.quality.getSelectedItem();
    }

    public JComboBox getQualityComboBox() {
        return this.quality;
    }

    public List<String> getTrackNames() {
        return this.tableModel.trackNames;
    }

    public List<Integer> getTracksSelected() {
        List<Boolean> list = this.tableModel.getTracksSelected();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).booleanValue()) continue;
            arrayList.add(i + 1);
        }
        return arrayList;
    }

    public JCheckBox getUseCdErrorCorrection() {
        return this.useCdErrorCorrection;
    }

    public JTextField getYearTextField() {
        return this.yearTextField;
    }

    public void setTableData(CDInfo cDInfo) {
        this.tableModel.setCdInfo(cDInfo);
        this.tableModel.fireTableDataChanged();
    }

    public void updateArtistNames(CDInfo cDInfo) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : cDInfo.getArtists()) {
            if (!string.trim().equals("")) {
                arrayList.add(string);
                continue;
            }
            if (cDInfo.getArtist() != null && !cDInfo.getArtist().trim().equals("")) {
                arrayList.add(cDInfo.getArtist());
                continue;
            }
            arrayList.add(Artist.getUnknownArtist());
        }
        this.tableModel.setArtistNames(arrayList);
        this.tableModel.fireTableDataChanged();
    }

    public void updateComposerNames(List<String> list) {
        this.tableModel.setComposerNames(list);
        this.tableModel.fireTableDataChanged();
    }

    public void updateTrackNames(List<String> list) {
        this.tableModel.setTrackNames(list);
        this.tableModel.fireTableDataChanged();
    }

    private static class CdInfoTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7577681531593039707L;
        private transient CDInfo cdInfo;
        private List<String> trackNames = new ArrayList<String>();
        private List<String> artistNames = new ArrayList<String>();
        private List<String> composerNames = new ArrayList<String>();
        private List<Boolean> tracksSelected;

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            if (n == 1) {
                return I18nUtils.getString("TITLE");
            }
            if (n == 2) {
                return I18nUtils.getString("ARTIST");
            }
            if (n == 3) {
                return I18nUtils.getString("COMPOSER");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.cdInfo != null ? this.cdInfo.getTracks() : 0;
        }

        public List<Boolean> getTracksSelected() {
            return this.tracksSelected;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.tracksSelected.get(n);
            }
            if (n2 == 1) {
                if (n > this.trackNames.size() - 1) {
                    this.trackNames.add(n, StringUtils.getString(I18nUtils.getString("TRACK"), " ", n + 1));
                    return StringUtils.getString(I18nUtils.getString("TRACK"), " ", n + 1);
                }
                if (n < this.trackNames.size()) {
                    return this.trackNames.get(n);
                }
                this.trackNames.add(n, StringUtils.getString(I18nUtils.getString("TRACK"), " ", n + 1));
                return StringUtils.getString(I18nUtils.getString("TRACK"), " ", n + 1);
            }
            if (n2 == 2) {
                if (n > this.artistNames.size() - 1) {
                    if (this.cdInfo.getArtist() != null) {
                        return this.cdInfo.getArtist();
                    }
                    return Artist.getUnknownArtist();
                }
                return this.artistNames.get(n);
            }
            if (n2 == 4) {
                return this.cdInfo.getDurations().get(n);
            }
            if (n > this.composerNames.size() - 1) {
                this.composerNames.add(n, "");
                return "";
            }
            return this.composerNames.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 != 4;
        }

        public void setArtistNames(List<String> list) {
            this.artistNames = list;
        }

        public void setCdInfo(CDInfo cDInfo) {
            if (cDInfo != null) {
                this.cdInfo = cDInfo;
                if (this.tracksSelected == null) {
                    this.tracksSelected = new ArrayList<Boolean>();
                }
                this.tracksSelected.clear();
                for (int i = 0; i < cDInfo.getTracks(); ++i) {
                    this.tracksSelected.add(true);
                }
            }
        }

        public void setComposerNames(List<String> list) {
            this.composerNames = list;
        }

        public void setTrackNames(List<String> list) {
            this.trackNames = list;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.tracksSelected.remove(n);
                this.tracksSelected.add(n, (Boolean)object);
            } else if (n2 == 1) {
                this.trackNames.set(n, (String)object);
            } else if (n2 == 2) {
                this.artistNames.set(n, (String)object);
            } else if (n2 == 3) {
                this.composerNames.set(n, (String)object);
            }
            this.fireTableCellUpdated(n, n2);
        }
    }
}

