/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.dialogs;

import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.sourceforge.atunes.gui.Fonts;
import net.sourceforge.atunes.gui.views.controls.AbstractCustomWindow;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.ImageUtils;
import org.jdesktop.swingx.border.DropShadowBorder;

public final class OSDDialog
extends AbstractCustomWindow {
    private static final long serialVersionUID = 8991547440913162267L;
    private static final int IMAGE_SIZE = 80;
    private int width;
    private int height = 100;
    private JLabel line1;
    private JLabel line2;
    private JLabel line3;
    private JLabel image;
    private static final int LINE1_Y_POSITION = 15;
    private static final int LINE2_Y_POSITION = 37;
    private static final int LINE3_Y_POSITION = 60;

    public OSDDialog(int n) {
        super(null, 0, 0);
        this.width = n;
        this.setSize(n, this.height);
        this.setFocusableWindowState(false);
        this.setAlwaysOnTop(true);
        this.add(this.getContent());
        GuiUtils.applyComponentOrientation(this);
    }

    public void setWidth(int n) {
        this.width = n;
        this.setSize(n, this.height);
    }

    private JPanel getContent() {
        JPanel jPanel = new JPanel(null);
        jPanel.setSize(this.width, this.height);
        this.image = new JLabel();
        this.image.setOpaque(true);
        this.line1 = new JLabel();
        this.line2 = new JLabel();
        this.line3 = new JLabel();
        this.line1.setFont(Fonts.getOsdLine1Font());
        this.line2.setFont(Fonts.getOsdLine2Font());
        this.line3.setFont(Fonts.getOsdLine3Font());
        this.line1.setHorizontalAlignment(0);
        this.line2.setHorizontalAlignment(0);
        this.line3.setHorizontalAlignment(0);
        jPanel.add(this.image);
        jPanel.add(this.line1);
        jPanel.add(this.line2);
        jPanel.add(this.line3);
        return jPanel;
    }

    public void setImage(ImageIcon imageIcon) {
        ImageIcon imageIcon2;
        if (imageIcon != null && (imageIcon2 = ImageUtils.resize(imageIcon, 80, 80)) != null) {
            this.image.setIcon(imageIcon2);
            this.image.setSize(imageIcon2.getIconWidth() + 5, imageIcon2.getIconHeight() + 5);
            this.image.setLocation(10, (this.height - 80) / 2);
            this.line1.setSize(this.width - 100, 20);
            this.line1.setLocation(90, 15);
            this.line2.setSize(this.width - 100, 20);
            this.line2.setLocation(90, 37);
            this.line3.setSize(this.width - 100, 20);
            this.line3.setLocation(90, 60);
        } else {
            this.image.setSize(0, 0);
            this.line1.setSize(this.width - 20, 20);
            this.line1.setLocation(10, 15);
            this.line2.setSize(this.width - 20, 20);
            this.line2.setLocation(10, 37);
            this.line3.setSize(this.width - 20, 20);
            this.line3.setLocation(10, 60);
        }
    }

    public void setLine1(String string) {
        this.line1.setText(string);
    }

    public void setLine2(String string) {
        this.line2.setText(string);
    }

    public void setLine3(String string) {
        this.line3.setText(string);
    }

    public void setRoundedBorders(boolean bl) {
        Area area = null;
        if (bl) {
            area = new Area(new RoundRectangle2D.Float(2.0f, 2.0f, this.width - 3, this.height - 3, 20.0f, 25.0f));
        }
        GuiUtils.setWindowShape(this, area);
    }

    public void setShadowBorder(boolean bl) {
        this.image.setBorder((Border)(bl ? new DropShadowBorder() : null));
    }
}

