/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class JTrayIcon
extends TrayIcon {
    private JDialog trayParent;
    private JPopupMenu popupMenu;
    private MouseListener trayIconMouseListener;
    private PopupMenuListener popupMenuListener;
    private boolean isLinux;
    private Action action;

    public JTrayIcon(Image image, boolean bl, Action action) {
        super(image);
        this.isLinux = bl;
        this.action = action;
        this.init();
    }

    private Point computeDisplayPoint(int n, int n2, Dimension dimension) {
        int n3 = n;
        int n4 = n2;
        if (n3 - dimension.width > 0) {
            n3 -= dimension.width;
        }
        if (n4 - dimension.height > 0) {
            n4 -= dimension.height;
        }
        return new Point(n3, n4);
    }

    private void init() {
        this.trayParent = new JDialog();
        this.trayParent.setSize(0, 0);
        this.trayParent.setUndecorated(true);
        this.trayParent.setAlwaysOnTop(true);
        this.trayParent.setVisible(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() == 1) {
                    JTrayIcon.this.action.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public synchronized void removeMouseListener(MouseListener mouseListener) {
        if (mouseListener == this.trayIconMouseListener) {
            return;
        }
        super.removeMouseListener(mouseListener);
    }

    public void setJTrayIconJPopupMenu(JTrayIconPopupMenu jTrayIconPopupMenu) {
        this.popupMenu = jTrayIconPopupMenu;
        this.popupMenuListener = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                JTrayIcon.this.trayParent.setVisible(false);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        };
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
        this.setTrayIconMouseListener();
    }

    @Override
    public void setPopupMenu(PopupMenu popupMenu) {
        throw new UnsupportedOperationException("use setJTrayIconPopupMenu(JTrayIconPopupMenu popup) instead");
    }

    private void setTrayIconMouseListener() {
        if (this.trayIconMouseListener == null) {
            this.trayIconMouseListener = new TrayIconMouseAdapter();
            this.addMouseListener(this.trayIconMouseListener);
        }
    }

    void showPopup(Point point) {
        this.trayParent.setVisible(true);
        this.trayParent.toFront();
        Point point2 = this.computeDisplayPoint(point.x, point.y, this.popupMenu.getPreferredSize());
        this.popupMenu.show(this.trayParent, point2.x - this.trayParent.getLocation().x, point2.y - this.trayParent.getLocation().y);
    }

    public class JTrayIconPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = -220434547680783992L;

        @Override
        public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
            if (popupMenuListener == JTrayIcon.this.popupMenuListener) {
                return;
            }
            super.removePopupMenuListener(popupMenuListener);
        }
    }

    private final class TrayIconMouseAdapter
    extends MouseAdapter {
        private TrayIconMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JTrayIcon.this.showPopup(mouseEvent.getPoint());
                if (!JTrayIcon.this.isLinux) {
                    JTrayIcon.this.trayParent.setVisible(false);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                if (JTrayIcon.this.trayParent.isVisible()) {
                    JTrayIcon.this.trayParent.setVisible(false);
                } else {
                    JTrayIcon.this.showPopup(mouseEvent.getPoint());
                }
            }
        }
    }
}

