/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sourceforge.atunes.gui.views.controls.CustomTextField;
import net.sourceforge.atunes.misc.SystemProperties;
import net.sourceforge.atunes.utils.I18nUtils;

public final class CustomJFileChooser
extends JPanel {
    private static final long serialVersionUID = 4713483251093570020L;
    private JTextField textField;
    private String result;

    public CustomJFileChooser(final Component component, int n, final int n2) {
        super(new GridBagLayout());
        final File file = new File(SystemProperties.USER_HOME);
        this.textField = new CustomTextField(file.getAbsolutePath(), n);
        JButton jButton = new JButton("...");
        jButton.setSize(this.textField.getPreferredSize().height, this.textField.getPreferredSize().height);
        jButton.setPreferredSize(jButton.getSize());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser(CustomJFileChooser.this.textField.getText());
                jFileChooser.setFileSelectionMode(n2);
                jFileChooser.setSelectedFile(file);
                if (n2 == 1) {
                    jFileChooser.setDialogTitle(I18nUtils.getString("SELECT_FOLDER"));
                }
                if (jFileChooser.showDialog(component, null) == 0) {
                    CustomJFileChooser.this.result = jFileChooser.getSelectedFile().getAbsolutePath();
                    CustomJFileChooser.this.textField.setText(CustomJFileChooser.this.result);
                } else {
                    CustomJFileChooser.this.result = null;
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.textField, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)jButton, gridBagConstraints);
    }

    public String getResult() {
        this.result = this.textField.getText();
        return this.result;
    }

    public void setText(String string) {
        this.textField.setText(string);
        this.result = string;
    }
}

