/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import com.jhlabs.image.PerspectiveFilter;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.sourceforge.atunes.utils.ImageUtils;

public final class Cover3D
extends JPanel {
    private static final long serialVersionUID = -3836270786764203330L;
    private static final int GAP = 10;
    private static final float OPACITY = 0.5f;
    private static final float FADE_HEIGHT = 0.4f;
    private int angle;
    private BufferedImage image;
    private BufferedImage reflectedImage;

    public Cover3D(int n) {
        this.angle = n;
        this.setOpaque(false);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.image == null) {
            super.paintComponent(graphics);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.image.getWidth();
        int n4 = this.image.getHeight();
        graphics2D.translate((n - n3) / 2, n2 / 2 - n4 / 2);
        graphics2D.drawRenderedImage(this.image, null);
        graphics2D.translate(0, 2 * n4 + 10);
        graphics2D.scale(1.0, -1.0);
        graphics2D.drawRenderedImage(this.reflectedImage, null);
    }

    public void setImage(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.image = ImageUtils.toBufferedImage(imageIcon.getImage());
            int n = imageIcon.getIconWidth();
            int n2 = imageIcon.getIconHeight();
            if (this.angle != 0) {
                PerspectiveFilter perspectiveFilter = new PerspectiveFilter(0.0f, (float)this.angle, (float)(n - this.angle / 2), (float)((int)((double)this.angle * 1.6666666666666667)), (float)(n - this.angle / 2), (float)n2, 0.0f, (float)(n2 + this.angle));
                this.image = perspectiveFilter.filter(this.image, null);
            }
            int n3 = this.image.getWidth();
            int n4 = this.image.getHeight();
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.drawRenderedImage(this.image, null);
            graphics2D.setComposite(AlphaComposite.getInstance(6));
            graphics2D.setPaint(new GradientPaint(0.0f, (float)n4 * 0.4f, new Color(0.0f, 0.0f, 0.0f, 0.0f), 0.0f, n4, new Color(0.0f, 0.0f, 0.0f, 0.5f)));
            graphics2D.fillRect(0, 0, n3, n4);
            graphics2D.dispose();
            if (this.angle != 0) {
                PerspectiveFilter perspectiveFilter = new PerspectiveFilter(0.0f, 0.0f, (float)(n - this.angle / 2), (float)(this.angle * 2), (float)(n - this.angle / 2), (float)(n2 + this.angle * 2), 0.0f, (float)n2);
                this.reflectedImage = perspectiveFilter.filter(bufferedImage, null);
            } else {
                this.reflectedImage = bufferedImage;
            }
        } else {
            this.image = null;
            this.reflectedImage = null;
        }
        this.invalidate();
        this.repaint();
    }
}

