/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.views.controls;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sourceforge.atunes.gui.views.controls.ScrollableFlowPanel;

public final class ByImageChoosingPanel<T>
extends ScrollableFlowPanel {
    private static final long serialVersionUID = -3541046889511348904L;
    private Set<CustomJRadioButton> buttons = new HashSet<CustomJRadioButton>();
    private ButtonGroup buttonGroup = new ButtonGroup();

    public ByImageChoosingPanel(List<? extends ImageEntry<T>> list) {
        this.setLayout(new FlowLayout(3, 20, 20));
        this.init(list);
    }

    private void init(List<? extends ImageEntry<T>> list) {
        for (ImageEntry<T> imageEntry : list) {
            JLabel jLabel = new JLabel();
            final CustomJRadioButton customJRadioButton = new CustomJRadioButton(imageEntry.getObject());
            customJRadioButton.setFocusPainted(false);
            jLabel.setIcon(imageEntry.getImage());
            this.buttons.add(customJRadioButton);
            this.buttonGroup.add(customJRadioButton);
            jLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    customJRadioButton.setSelected(!customJRadioButton.isSelected());
                }
            });
            JPanel jPanel = this.createPanel(jLabel, customJRadioButton);
            this.add(jPanel);
        }
    }

    private JPanel createPanel(JLabel jLabel, CustomJRadioButton customJRadioButton) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)customJRadioButton, gridBagConstraints);
        return jPanel;
    }

    public void setSelectedItem(T t) {
        for (CustomJRadioButton customJRadioButton : this.buttons) {
            if (!customJRadioButton.getObject().equals(t)) continue;
            customJRadioButton.setSelected(true);
        }
    }

    public T getSelectedItem() {
        for (CustomJRadioButton customJRadioButton : this.buttons) {
            if (!customJRadioButton.isSelected()) continue;
            return customJRadioButton.getObject();
        }
        return null;
    }

    private class CustomJRadioButton
    extends JRadioButton {
        private static final long serialVersionUID = -6933585654529381134L;
        private T object;

        public CustomJRadioButton(T t) {
            this.object = t;
        }

        public T getObject() {
            return this.object;
        }
    }

    public static class ImageEntry<U> {
        private U object;
        private ImageIcon image;

        public ImageEntry(U u, ImageIcon imageIcon) {
            this.object = u;
            this.image = imageIcon;
        }

        public U getObject() {
            return this.object;
        }

        public ImageIcon getImage() {
            return this.image;
        }
    }
}

