/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import net.sourceforge.atunes.misc.log.Logger;

public final class TransferableList<T>
implements Transferable {
    private Logger logger;
    public static final String mimeType = "aTunes/objects; class=java.io.InputStream";
    private List<T> list;

    public TransferableList(List<T> list) {
        this.list = list;
    }

    @Override
    public List<T> getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        return this.list;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[1];
        try {
            dataFlavorArray[0] = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.getLogger().internalError(classNotFoundException);
        }
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.getMimeType().equalsIgnoreCase(mimeType);
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = new Logger();
        }
        return this.logger;
    }
}

