/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.atunes.gui.model.AbstractColumnSetTableModel;
import net.sourceforge.atunes.model.AudioObject;

public final class NavigationTableModel
extends AbstractColumnSetTableModel {
    private List<AudioObject> audioObjects;

    @Override
    public int getRowCount() {
        return this.audioObjects != null ? this.audioObjects.size() : 0;
    }

    public AudioObject getAudioObjectAt(int n) {
        return this.audioObjects != null ? this.audioObjects.get(n) : null;
    }

    public List<AudioObject> getAudioObjects() {
        return this.audioObjects;
    }

    public List<AudioObject> getAudioObjectsAt(int[] nArray) {
        ArrayList<AudioObject> arrayList = new ArrayList<AudioObject>();
        for (int n : nArray) {
            arrayList.add(this.getAudioObjectAt(n));
        }
        return arrayList;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        AudioObject audioObject = this.getAudioObjectAt(n);
        if (audioObject == null) {
            return null;
        }
        return this.getColumn(n2).getValueFor(audioObject);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setSongs(List<AudioObject> list) {
        this.audioObjects = list;
        this.refresh(1);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
    }

    @Override
    public void sort(Comparator<AudioObject> comparator) {
        Collections.sort(this.audioObjects, comparator);
        this.refresh(0);
    }

    public static enum Property {
        NO_PROPERTIES,
        FAVORITE,
        NOT_LISTENED_ENTRY,
        DOWNLOADED_ENTRY,
        OLD_ENTRY;

    }
}

