/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.frame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import net.sourceforge.atunes.gui.frame.Frame;
import net.sourceforge.atunes.gui.frame.FrameState;
import net.sourceforge.atunes.gui.views.bars.ToolBar;
import net.sourceforge.atunes.gui.views.controls.CustomDialog;
import net.sourceforge.atunes.gui.views.controls.CustomFrame;
import net.sourceforge.atunes.gui.views.controls.playList.PlayListTable;
import net.sourceforge.atunes.gui.views.dialogs.UpdateDialog;
import net.sourceforge.atunes.gui.views.menus.ApplicationMenuBar;
import net.sourceforge.atunes.gui.views.panels.AudioObjectPropertiesPanel;
import net.sourceforge.atunes.gui.views.panels.ContextPanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTablePanel;
import net.sourceforge.atunes.gui.views.panels.NavigationTreePanel;
import net.sourceforge.atunes.gui.views.panels.PlayListPanel;
import net.sourceforge.atunes.gui.views.panels.PlayerControlsPanel;
import net.sourceforge.atunes.kernel.modules.gui.GuiHandler;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.updates.ApplicationVersion;
import net.sourceforge.atunes.utils.GuiUtils;
import net.sourceforge.atunes.utils.I18nUtils;

public final class MultipleFrame
implements Frame {
    private static final int STICKY_INSET = 30;
    private static int SCREEN_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width;
    private static int SCREEN_HEIGHT = Toolkit.getDefaultToolkit().getScreenSize().height;
    private static final int NONE = -1;
    private static final int NORTH = 0;
    private static final int SOUTH = 1;
    private static final int WEST = 2;
    private static final int EAST = 3;
    private static final Dimension frameDimension = new Dimension(500, 400);
    private static final Dimension navigatorDimension = new Dimension(300, 300);
    private static final Dimension filePropertiesDimension = new Dimension(500, 130);
    private static final Dimension contextDimension = new Dimension(300, 689);
    private CustomFrame frame;
    private FrameState frameState;
    private CustomDialog navigationTreeDialog;
    private CustomDialog navigationTableDialog;
    private CustomDialog audioObjectPropertiesDialog;
    private CustomDialog contextDialog;
    private ApplicationMenuBar menuBar;
    private ToolBar toolBar;
    private NavigationTreePanel navigationTreePanel;
    private NavigationTablePanel navigationTablePanel;
    private PlayListPanel playListPanel;
    private PlayerControlsPanel playerControlsPanel;
    private AudioObjectPropertiesPanel audioObjectPropertiesPanel;
    private ContextPanel contextPanel;
    private List<Window> windows = new ArrayList<Window>();

    private void addContentToAudioObjectProperties() {
        this.audioObjectPropertiesPanel = new AudioObjectPropertiesPanel();
        this.audioObjectPropertiesDialog.add(this.audioObjectPropertiesPanel);
        GuiUtils.applyComponentOrientation(this.audioObjectPropertiesPanel);
    }

    private void addContentToFrame() {
        GuiUtils.addAppIcons(this.frame);
        this.playerControlsPanel = new PlayerControlsPanel();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.getToolBar(), "North");
        jPanel.add((Component)this.getPlayListPanel(), "Center");
        jPanel.add((Component)this.playerControlsPanel, "South");
        GuiUtils.applyComponentOrientation(jPanel);
        this.frame.add(jPanel);
    }

    @Override
    public NavigationTreePanel getNavigationTreePanel() {
        if (this.navigationTreePanel == null) {
            this.navigationTreePanel = new NavigationTreePanel();
        }
        return this.navigationTreePanel;
    }

    @Override
    public NavigationTablePanel getNavigationTablePanel() {
        if (this.navigationTablePanel == null) {
            this.navigationTablePanel = new NavigationTablePanel();
        }
        return this.navigationTablePanel;
    }

    private void addContentToContext() {
        this.contextPanel = new ContextPanel();
        this.contextDialog.add(this.contextPanel);
        GuiUtils.applyComponentOrientation(this.contextPanel);
    }

    @Override
    public void create(FrameState frameState) {
        Dimension dimension;
        this.frameState = frameState;
        this.menuBar = new ApplicationMenuBar();
        this.toolBar = new ToolBar();
        this.frame = this.getNewFrame("", MultipleFrame.frameDimension.width, MultipleFrame.frameDimension.height, null, -1, frameDimension);
        this.frame.setJMenuBar(this.menuBar);
        Point point = null;
        if (ApplicationState.getInstance().getMultipleViewXPosition() > 0 && ApplicationState.getInstance().getMultipleViewYPosition() > 0) {
            point = new Point(ApplicationState.getInstance().getMultipleViewXPosition(), ApplicationState.getInstance().getMultipleViewYPosition());
        }
        if (point == null) {
            dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.frame.setLocation((dimension.width - MultipleFrame.frameDimension.width) / 2, 100);
        } else {
            this.frame.setLocation(point.x, point.y);
        }
        dimension = null;
        if (ApplicationState.getInstance().getMultipleViewWidth() != 0 && ApplicationState.getInstance().getMultipleViewHeight() != 0) {
            dimension = new Dimension(ApplicationState.getInstance().getMultipleViewWidth(), ApplicationState.getInstance().getMultipleViewHeight());
        }
        if (dimension != null) {
            this.frame.setSize(dimension);
        }
        this.addContentToFrame();
        this.navigationTreePanel = new NavigationTreePanel();
        this.navigationTablePanel = new NavigationTablePanel();
        this.navigationTreeDialog = this.getNewDialog(this.frame, I18nUtils.getString("NAVIGATION_TREE"), MultipleFrame.navigatorDimension.width, MultipleFrame.navigatorDimension.height, this.frame, 2, navigatorDimension);
        this.navigationTreeDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultipleFrame.this.toolBar.getShowNavigationTree().setSelected(false);
                MultipleFrame.this.toolBar.getShowNavigationTree().getAction().actionPerformed(null);
            }
        });
        this.navigationTreeDialog.add(this.navigationTreePanel);
        GuiUtils.applyComponentOrientation(this.navigationTreeDialog);
        this.navigationTableDialog = this.getNewDialog(this.frame, I18nUtils.getString("NAVIGATION_TABLE"), MultipleFrame.navigatorDimension.width, MultipleFrame.navigatorDimension.height, this.frame, 1, navigatorDimension);
        this.navigationTableDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultipleFrame.this.toolBar.getShowNavigationTable().setSelected(false);
                MultipleFrame.this.toolBar.getShowNavigationTable().getAction().actionPerformed(null);
            }
        });
        this.navigationTableDialog.add(this.navigationTablePanel);
        GuiUtils.applyComponentOrientation(this.navigationTableDialog);
        this.audioObjectPropertiesDialog = this.getNewDialog(this.frame, I18nUtils.getString("PROPERTIES"), MultipleFrame.filePropertiesDimension.width, MultipleFrame.filePropertiesDimension.height, this.frame, 1, filePropertiesDimension);
        this.addContentToAudioObjectProperties();
        this.audioObjectPropertiesDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultipleFrame.this.toolBar.getShowAudioObjectProperties().setSelected(false);
                MultipleFrame.this.toolBar.getShowAudioObjectProperties().getAction().actionPerformed(null);
            }
        });
        this.contextDialog = this.getNewDialog(this.frame, I18nUtils.getString("CONTEXT_INFORMATION"), MultipleFrame.contextDimension.width, MultipleFrame.contextDimension.height, this.frame, 3, contextDimension);
        this.addContentToContext();
        this.contextDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MultipleFrame.this.toolBar.getShowContext().setSelected(false);
                MultipleFrame.this.toolBar.getShowContext().getAction().actionPerformed(null);
            }
        });
    }

    @Override
    public ApplicationMenuBar getAppMenuBar() {
        return this.menuBar;
    }

    @Override
    public ContextPanel getContextPanel() {
        return this.contextPanel;
    }

    @Override
    public int getExtendedState() {
        return this.frame.getExtendedState();
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public Point getLocation() {
        return this.frame.getLocation();
    }

    @Override
    public PlayerControlsPanel getPlayerControls() {
        return this.playerControlsPanel;
    }

    @Override
    public PlayListPanel getPlayListPanel() {
        if (this.playListPanel == null) {
            this.playListPanel = new PlayListPanel();
        }
        return this.playListPanel;
    }

    @Override
    public PlayListTable getPlayListTable() {
        return this.getPlayListPanel().getPlayListTable();
    }

    @Override
    public AudioObjectPropertiesPanel getPropertiesPanel() {
        return this.audioObjectPropertiesPanel;
    }

    @Override
    public Dimension getSize() {
        return this.frame.getSize();
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public boolean isVisible() {
        return this.frame.isVisible();
    }

    @Override
    public void setCenterStatusBarText(String string, String string2) {
    }

    @Override
    public void setDefaultCloseOperation(int n) {
        this.frame.setDefaultCloseOperation(n);
        this.navigationTreeDialog.setDefaultCloseOperation(n);
        this.navigationTableDialog.setDefaultCloseOperation(n);
        this.audioObjectPropertiesDialog.setDefaultCloseOperation(n);
        this.contextDialog.setDefaultCloseOperation(n);
    }

    @Override
    public void setExtendedState(int n) {
    }

    @Override
    public void setLeftStatusBarText(String string, String string2) {
    }

    @Override
    public void setLocation(Point point) {
    }

    @Override
    public void setLocationRelativeTo(Component component) {
        this.frame.setLocationRelativeTo(component);
    }

    @Override
    public void setRightStatusBarText(String string, String string2) {
    }

    @Override
    public void setStatusBarDeviceLabelText(String string) {
    }

    @Override
    public void setTitle(String string) {
        this.frame.setTitle(string);
    }

    @Override
    public void setVisible(boolean bl) {
        this.frame.setVisible(bl);
        if (!bl) {
            this.navigationTreeDialog.setVisible(bl);
            this.navigationTableDialog.setVisible(bl);
        }
        if (!bl || ApplicationState.getInstance().isShowAudioObjectProperties()) {
            this.audioObjectPropertiesDialog.setVisible(bl);
        }
        if (!bl || ApplicationState.getInstance().isUseContext()) {
            this.contextDialog.setVisible(bl);
        }
    }

    @Override
    public void showContextPanel(boolean bl) {
        this.contextDialog.setVisible(bl);
    }

    @Override
    public void showNavigationTree(boolean bl) {
        this.navigationTreeDialog.setVisible(bl);
    }

    @Override
    public void showNavigationTable(boolean bl) {
        this.navigationTableDialog.setVisible(bl);
    }

    @Override
    public JProgressBar getProgressBar() {
        return null;
    }

    @Override
    public void showSongProperties(boolean bl) {
        this.audioObjectPropertiesDialog.setVisible(bl);
    }

    @Override
    public void showStatusBar(boolean bl) {
    }

    @Override
    public void showToolBar(boolean bl) {
        this.getToolBar().setVisible(bl);
    }

    @Override
    public void showDeviceInfo(boolean bl) {
    }

    @Override
    public void showNewPodcastFeedEntriesInfo(boolean bl) {
        if (bl) {
            JOptionPane.showMessageDialog(this.frame, I18nUtils.getString("NEW_PODCAST_ENTRIES"));
        }
    }

    @Override
    public void showNewVersionInfo(boolean bl, ApplicationVersion applicationVersion) {
        if (bl) {
            new UpdateDialog(applicationVersion, null).setVisible(true);
        }
    }

    private CustomDialog getNewDialog(CustomFrame customFrame, String string, int n, int n2, Window window, int n3, Dimension dimension) {
        final CustomDialog customDialog = new CustomDialog(this.frame, n, n2);
        customDialog.setTitle(string);
        customDialog.setMinimumSize(dimension);
        Timer timer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleFrame.this.positionChanged(customDialog);
            }
        });
        timer.setRepeats(false);
        customDialog.addComponentListener(new CustomDialogComponentAdapter(timer));
        if (this.windows.isEmpty() || n3 == -1) {
            customDialog.setLocation(50, 50);
        } else {
            Rectangle rectangle = window.getBounds();
            if (n3 == 0) {
                customDialog.setLocation(rectangle.x, rectangle.y - n2 - 1);
            } else if (n3 == 1) {
                customDialog.setLocation(rectangle.x, rectangle.y + rectangle.height - 1);
            } else if (n3 == 3) {
                customDialog.setLocation(rectangle.x + rectangle.width - 1, rectangle.y);
            } else {
                int n4 = rectangle.x - n + 1;
                customDialog.setLocation(n4 >= 0 ? n4 : 0, rectangle.y);
            }
        }
        this.windows.add(customDialog);
        return customDialog;
    }

    private CustomFrame getNewFrame(String string, int n, int n2, Window window, int n3, Dimension dimension) {
        final CustomFrame customFrame = new CustomFrame(string, n, n2, this.frame == null ? null : this.frame);
        Timer timer = new Timer(400, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleFrame.this.positionChanged(customFrame);
            }
        });
        timer.setRepeats(false);
        customFrame.addComponentListener(new FrameComponentAdapter(timer));
        if (this.frame == null) {
            this.frame = customFrame;
            this.frame.addWindowListener(new FrameWindowAdapter());
        }
        if (this.windows.isEmpty() || n3 == -1) {
            customFrame.setLocationRelativeTo(null);
        } else {
            Rectangle rectangle = window.getBounds();
            if (n3 == 0) {
                customFrame.setLocation(rectangle.x, rectangle.y - n2 - 1);
            } else if (n3 == 1) {
                customFrame.setLocation(rectangle.x, rectangle.y + rectangle.height - 1);
            } else if (n3 == 3) {
                customFrame.setLocation(rectangle.x + rectangle.width - 1, rectangle.y);
            } else {
                customFrame.setLocation(rectangle.x - n + 1, rectangle.y);
            }
        }
        this.windows.add(customFrame);
        return customFrame;
    }

    protected void positionChanged(Window window) {
        int n = window.getBounds().x;
        int n2 = window.getBounds().y;
        n = n < 30 ? 0 : n;
        n = SCREEN_WIDTH - (n + window.getSize().width) < 30 ? SCREEN_WIDTH - window.getSize().width : n;
        n2 = n2 < 30 ? 0 : n2;
        int n3 = n2 = SCREEN_HEIGHT - (n2 + window.getSize().height) < 30 ? SCREEN_HEIGHT - window.getSize().height : n2;
        if (this.windows.size() > 1) {
            for (int i = 0; i < this.windows.size(); ++i) {
                Window window2 = this.windows.get(i);
                if (window == window2 || !window2.isVisible()) continue;
                int n4 = n - window2.getBounds().x;
                int n5 = n2 - window2.getBounds().y;
                int n6 = window2.getBounds().x + (n4 > 0 ? window2.getBounds().width - 1 : -window.getBounds().width + 1);
                int n7 = window2.getBounds().y + (n5 > 0 ? window2.getBounds().height - 1 : -window.getBounds().height + 1);
                int n8 = n6 - n;
                int n9 = n7 - n2;
                if (Math.abs(n8) >= 30 && Math.abs(n9) >= 30) continue;
                if (Math.abs(n8) > Math.abs(n9)) {
                    n2 = n7;
                    break;
                }
                n = n6;
                break;
            }
        }
        if (n != window.getBounds().x || n2 != window.getBounds().y) {
            window.setLocation(n, n2);
        }
    }

    @Override
    public FrameState getFrameState() {
        return this.frameState;
    }

    private static final class CustomDialogComponentAdapter
    extends ComponentAdapter {
        private final Timer t;

        private CustomDialogComponentAdapter(Timer timer) {
            this.t = timer;
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.t.start();
        }
    }

    private static final class FrameComponentAdapter
    extends ComponentAdapter {
        private final Timer t;

        private FrameComponentAdapter(Timer timer) {
            this.t = timer;
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.t.start();
        }
    }

    private static class FrameWindowAdapter
    extends WindowAdapter {
        private FrameWindowAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            GuiHandler.getInstance().finish();
        }
    }
}

