/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui.frame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import net.sourceforge.atunes.gui.frame.AbstractSingleFrame;
import net.sourceforge.atunes.gui.frame.Frame;
import net.sourceforge.atunes.gui.frame.FrameState;
import net.sourceforge.atunes.gui.views.controls.CustomSplitPane;

public final class DefaultSingleFrame
extends AbstractSingleFrame
implements Frame {
    private static final long serialVersionUID = 1L;
    private static final String RIGHT_VERTICAL_SPLIT_PANE = "2";
    private static final String LEFT_VERTICAL_SPLIT_PANE = "1";
    private static final String NAVIGATOR_SPLIT_PANE = "3";
    private CustomSplitPane leftVerticalSplitPane;
    private CustomSplitPane rightVerticalSplitPane;
    private CustomSplitPane navigatorSplitPane;

    @Override
    protected Container getContentPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.leftVerticalSplitPane = new CustomSplitPane(1);
        this.setJMenuBar(this.getAppMenuBar());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.rightVerticalSplitPane = new CustomSplitPane(1);
        this.rightVerticalSplitPane.setBorder(BorderFactory.createEmptyBorder());
        this.rightVerticalSplitPane.setResizeWeight(1.0);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this.getPlayListPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        jPanel3.add((Component)this.getPropertiesPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        jPanel3.add((Component)this.getPlayerControls(), gridBagConstraints);
        this.rightVerticalSplitPane.setLeftComponent(jPanel3);
        this.rightVerticalSplitPane.setRightComponent(this.getContextPanel());
        jPanel2.add((Component)this.rightVerticalSplitPane, "Center");
        this.navigatorSplitPane = new CustomSplitPane(0);
        this.navigatorSplitPane.setLeftComponent(this.getNavigationTreePanel());
        this.navigatorSplitPane.setRightComponent(this.getNavigationTablePanel());
        this.navigatorSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefaultSingleFrame.this.getFrameState().putSplitPaneDividerPos(DefaultSingleFrame.NAVIGATOR_SPLIT_PANE, (Integer)propertyChangeEvent.getNewValue());
            }
        });
        this.leftVerticalSplitPane.setLeftComponent(this.navigatorSplitPane);
        this.leftVerticalSplitPane.setRightComponent(jPanel2);
        this.leftVerticalSplitPane.setResizeWeight(0.2);
        this.leftVerticalSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefaultSingleFrame.this.getFrameState().putSplitPaneDividerPos(DefaultSingleFrame.LEFT_VERTICAL_SPLIT_PANE, (Integer)propertyChangeEvent.getNewValue());
            }
        });
        this.rightVerticalSplitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DefaultSingleFrame.this.getFrameState().putSplitPaneDividerPos(DefaultSingleFrame.RIGHT_VERTICAL_SPLIT_PANE, (Integer)propertyChangeEvent.getNewValue());
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)this.getToolBar(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)this.leftVerticalSplitPane, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.getStatusBar(), gridBagConstraints);
        return jPanel;
    }

    @Override
    protected void setupSplitPaneDividerPosition(FrameState frameState) {
        DefaultSingleFrame.applySplitPaneDividerPosition(this.leftVerticalSplitPane, frameState.getSplitPaneDividerPos(LEFT_VERTICAL_SPLIT_PANE), 0.5);
        DefaultSingleFrame.applySplitPaneDividerPosition(this.rightVerticalSplitPane, frameState.getSplitPaneDividerPos(RIGHT_VERTICAL_SPLIT_PANE), 0.5);
        DefaultSingleFrame.applySplitPaneDividerPosition(this.navigatorSplitPane, frameState.getSplitPaneDividerPos(NAVIGATOR_SPLIT_PANE), 0.5);
        this.setWindowSize();
    }

    @Override
    public void showContextPanel(boolean bl) {
        this.applyVisibility(bl, RIGHT_VERTICAL_SPLIT_PANE, this.getContextPanel(), this.rightVerticalSplitPane);
    }

    @Override
    public void showNavigationTree(boolean bl) {
        this.applyVisibility(bl, NAVIGATOR_SPLIT_PANE, this.getNavigationTreePanel(), this.navigatorSplitPane);
    }

    @Override
    public void showNavigationTable(boolean bl) {
        this.applyVisibility(bl, NAVIGATOR_SPLIT_PANE, this.getNavigationTablePanel(), this.navigatorSplitPane);
    }
}

