/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.Timer;
import net.sourceforge.atunes.utils.GuiUtils;

public class WindowFader {
    private WeakReference<Window> window;
    private Timer fadeInTimer;
    private Timer fadeOutTimer;
    private int currentOpacity;
    private int duration;

    public WindowFader(Window window, int n) {
        this.window = new WeakReference<Window>(window);
        this.duration = n;
    }

    public void fadeIn() {
        this.stop();
        Window window = (Window)this.window.get();
        if (window != null) {
            GuiUtils.setWindowOpacity(window, (float)this.currentOpacity / 100.0f);
            window.setVisible(true);
        }
        this.fadeInTimer = new Timer(this.duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowFader.this.currentOpacity += 20;
                if (WindowFader.this.currentOpacity <= 100) {
                    Window window = (Window)WindowFader.this.window.get();
                    if (window != null) {
                        GuiUtils.setWindowOpacity(window, (float)WindowFader.this.currentOpacity / 100.0f);
                        window.repaint();
                    }
                } else {
                    WindowFader.this.fadeInFinished();
                    WindowFader.this.currentOpacity = 100;
                    WindowFader.this.fadeInTimer.stop();
                }
            }
        });
        this.fadeInTimer.setRepeats(true);
        this.fadeInTimer.start();
    }

    public void fadeOut() {
        this.stop();
        this.fadeOutTimer = new Timer(this.duration, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WindowFader.this.currentOpacity -= 10;
                if (WindowFader.this.currentOpacity >= 0) {
                    Window window = (Window)WindowFader.this.window.get();
                    if (window != null) {
                        GuiUtils.setWindowOpacity(window, (float)WindowFader.this.currentOpacity / 100.0f);
                        window.repaint();
                    }
                } else {
                    WindowFader.this.fadeOutFinished();
                    WindowFader.this.fadeOutTimer.stop();
                    WindowFader.this.currentOpacity = 0;
                }
            }
        });
        this.fadeOutTimer.setRepeats(true);
        this.fadeOutTimer.start();
    }

    protected void fadeOutFinished() {
        Window window = (Window)this.window.get();
        if (window != null) {
            window.dispose();
        }
    }

    protected void fadeInFinished() {
    }

    private void stop() {
        if (this.fadeInTimer != null) {
            this.fadeInTimer.stop();
            this.fadeInTimer = null;
        }
        if (this.fadeOutTimer != null) {
            this.fadeOutTimer.stop();
            this.fadeOutTimer = null;
        }
    }

    public void clear() {
        this.stop();
        this.currentOpacity = 0;
        Window window = (Window)this.window.get();
        if (window != null) {
            GuiUtils.setWindowOpacity(window, 1.0f);
            window.dispose();
        }
    }
}

