/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.atunes.gui;

import java.awt.Font;
import net.sourceforge.atunes.gui.lookandfeel.LookAndFeelSelector;
import net.sourceforge.atunes.gui.views.dialogs.FontChooserDialog;
import net.sourceforge.atunes.kernel.modules.state.ApplicationState;
import net.sourceforge.atunes.kernel.modules.state.beans.FontBean;

public final class Fonts {
    private static final boolean USE_FONT_SMOOTHING_SETTINGS_FROM_OS_DEFAULT_VALUE = false;
    private static final boolean USE_FONT_SMOOTHING_DEFAULT_VALUE = true;
    private static Font aboutBigFont;
    private static Font appVersionLittleFont;
    private static Font buttonFont;
    private static Font generalBoldFont;
    private static Font smallFont;
    private static Font playListFont;
    private static Font playListSelectedItemFont;
    private static Font contextInformationBigFont;
    private static Font propertiesDialogBigFont;
    private static Font chartTitleFont;
    private static Font chartTickLabelFont;
    private static Font osdLine1Font;
    private static Font osdLine2Font;
    private static Font osdLine3Font;
    private static Font fullScreenLine1Font;
    private static Font font;

    private Fonts() {
    }

    public static void initializeFonts() {
        FontChooserDialog.FontSettings fontSettings = ApplicationState.getInstance().getFontSettings();
        if (fontSettings != null) {
            font = fontSettings.getFont().toFont();
            LookAndFeelSelector.getInstance().getCurrentLookAndFeel().initializeFonts(font);
        } else {
            if ("zh".equals(ApplicationState.getInstance().getLocale().getLanguage()) || "ja".equals(ApplicationState.getInstance().getLocale().getLanguage())) {
                font = new Font("SansSerif", 0, 12);
                LookAndFeelSelector.getInstance().getCurrentLookAndFeel().initializeFonts(font);
            } else {
                font = LookAndFeelSelector.getInstance().getCurrentLookAndFeel().getDefaultFont();
            }
            ApplicationState.getInstance().setFontSettings(new FontChooserDialog.FontSettings(new FontBean(font), true, false));
        }
    }

    public static void setFontSmoothing() {
        FontChooserDialog.FontSettings fontSettings = ApplicationState.getInstance().getFontSettings();
        if (fontSettings != null && !fontSettings.isUseFontSmoothingSettingsFromOs()) {
            if (fontSettings.isUseFontSmoothing()) {
                System.setProperty("awt.useSystemAAFontSettings", "lcd");
            } else {
                System.setProperty("awt.useSystemAAFontSettings", "false");
            }
        } else {
            System.setProperty("awt.useSystemAAFontSettings", "lcd");
        }
    }

    public static Font getAboutBigFont() {
        if (aboutBigFont == null) {
            aboutBigFont = font.deriveFont((float)font.getSize() + 8.0f);
        }
        return aboutBigFont;
    }

    public static Font getAppVersionLittleFont() {
        if (appVersionLittleFont == null) {
            appVersionLittleFont = font.deriveFont((float)font.getSize() + 1.0f);
        }
        return appVersionLittleFont;
    }

    public static Font getButtonFont() {
        if (buttonFont == null) {
            buttonFont = font;
        }
        return buttonFont;
    }

    public static Font getGeneralBoldFont() {
        if (generalBoldFont == null) {
            generalBoldFont = font.deriveFont(1, font.getSize() + 1);
        }
        return generalBoldFont;
    }

    public static Font getSmallFont() {
        if (smallFont == null) {
            smallFont = font.deriveFont((float)font.getSize() - 1.0f);
        }
        return smallFont;
    }

    public static Font getPlayListFont() {
        if (playListFont == null) {
            playListFont = font;
        }
        return playListFont;
    }

    public static Font getPlayListSelectedItemFont() {
        if (playListSelectedItemFont == null) {
            playListSelectedItemFont = Fonts.getPlayListFont().deriveFont(1);
        }
        return playListSelectedItemFont;
    }

    public static Font getContextInformationBigFont() {
        if (contextInformationBigFont == null) {
            contextInformationBigFont = font.deriveFont((float)font.getSize() + 8.0f);
        }
        return contextInformationBigFont;
    }

    public static Font getPropertiesDialogBigFont() {
        if (propertiesDialogBigFont == null) {
            propertiesDialogBigFont = font.deriveFont((float)font.getSize() + 4.0f);
        }
        return propertiesDialogBigFont;
    }

    public static Font getChartTitleFont() {
        if (chartTitleFont == null) {
            chartTitleFont = font.deriveFont((float)font.getSize() - 1.0f);
        }
        return chartTitleFont;
    }

    public static Font getChartTickLabelFont() {
        if (chartTickLabelFont == null) {
            chartTickLabelFont = font.deriveFont((float)font.getSize() - 2.0f);
        }
        return chartTickLabelFont;
    }

    public static Font getOsdLine1Font() {
        if (osdLine1Font == null) {
            osdLine1Font = font.deriveFont(1, (float)font.getSize() + 4.0f);
        }
        return osdLine1Font;
    }

    public static Font getOsdLine2Font() {
        if (osdLine2Font == null) {
            osdLine2Font = font.deriveFont((float)font.getSize() + 2.0f);
        }
        return osdLine2Font;
    }

    public static Font getOsdLine3Font() {
        if (osdLine3Font == null) {
            osdLine3Font = Fonts.getOsdLine2Font();
        }
        return osdLine3Font;
    }

    public static Font getFullScreenLine1Font() {
        if (fullScreenLine1Font == null) {
            fullScreenLine1Font = font.deriveFont((float)font.getSize() + 25.0f);
        }
        return fullScreenLine1Font;
    }
}

