/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.datatype.Lyrics3Line;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.AbstractTagItem;
import org.jaudiotagger.tag.id3.ID3Compression;
import org.jaudiotagger.tag.id3.ID3SyncSafeInteger;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3Unsynchronization;
import org.jaudiotagger.tag.id3.ID3v22Frame;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frames;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyCOMM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodySYLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTALB;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTCOM;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTIT2;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTMOO;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTPE1;
import org.jaudiotagger.tag.id3.framebody.FrameBodyTXXX;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUSLT;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyAUT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAL;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyEAR;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyETT;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyINF;
import org.jaudiotagger.tag.lyrics3.FieldFrameBodyLYR;
import org.jaudiotagger.tag.lyrics3.Lyrics3v2Field;
import org.jaudiotagger.utils.EqualsUtil;

public class ID3v24Frame
extends AbstractID3v2Frame {
    private static Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{3}");
    protected static final int FRAME_DATA_LENGTH_SIZE = 4;
    protected static final int FRAME_ID_SIZE = 4;
    protected static final int FRAME_FLAGS_SIZE = 2;
    protected static final int FRAME_SIZE_SIZE = 4;
    protected static final int FRAME_ENCRYPTION_INDICATOR_SIZE = 1;
    protected static final int FRAME_GROUPING_INDICATOR_SIZE = 1;
    protected static final int FRAME_HEADER_SIZE = 10;
    private int encryptionMethod;
    private int groupIdentifier;

    public ID3v24Frame() {
    }

    public ID3v24Frame(String identifier) {
        super(identifier);
        this.statusFlags = new StatusFlags();
        this.encodingFlags = new EncodingFlags();
    }

    public ID3v24Frame(ID3v24Frame frame) {
        super(frame);
        this.statusFlags = new StatusFlags(frame.getStatusFlags().getOriginalFlags());
        this.encodingFlags = new EncodingFlags(frame.getEncodingFlags().getFlags());
    }

    private void createV24FrameFromV23Frame(ID3v23Frame frame) throws InvalidFrameException {
        this.identifier = ID3Tags.convertFrameID23To24(frame.getIdentifier());
        logger.finer("Creating V24frame from v23:" + frame.getIdentifier() + ":" + this.identifier);
        if (frame.getBody() instanceof FrameBodyUnsupported) {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
            this.frameBody.setHeader(this);
            this.identifier = frame.getIdentifier();
            logger.finer("V3:UnsupportedBody:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
        } else if (this.identifier != null) {
            if (frame.getIdentifier().equals("TXXX") && ((FrameBodyTXXX)frame.getBody()).getDescription().equals("MOOD")) {
                this.frameBody = new FrameBodyTMOO((FrameBodyTXXX)frame.getBody());
                this.frameBody.setHeader(this);
                this.identifier = this.frameBody.getIdentifier();
            } else {
                logger.finer("V3:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                this.frameBody = (AbstractTagFrameBody)ID3Tags.copyObject(frame.getBody());
                this.frameBody.setHeader(this);
            }
        } else if (ID3Tags.isID3v23FrameIdentifier(frame.getIdentifier())) {
            this.identifier = ID3Tags.forceFrameID23To24(frame.getIdentifier());
            if (this.identifier != null) {
                logger.info("V3:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
                this.frameBody.setHeader(this);
            } else {
                this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)frame.getBody());
                this.frameBody.setHeader(this);
                this.identifier = frame.getIdentifier();
                logger.finer("V3:Deprecated:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
            }
        } else {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
            this.frameBody.setHeader(this);
            this.identifier = frame.getIdentifier();
            logger.finer("V3:Unknown:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
        }
    }

    public ID3v24Frame(AbstractID3v2Frame frame) throws InvalidFrameException {
        if (frame instanceof ID3v24Frame) {
            throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
        }
        if (frame instanceof ID3v23Frame) {
            this.statusFlags = new StatusFlags((ID3v23Frame.StatusFlags)frame.getStatusFlags());
            this.encodingFlags = new EncodingFlags(frame.getEncodingFlags().getFlags());
        } else {
            this.statusFlags = new StatusFlags();
            this.encodingFlags = new EncodingFlags();
        }
        if (frame instanceof ID3v23Frame) {
            this.createV24FrameFromV23Frame((ID3v23Frame)frame);
        } else if (frame instanceof ID3v22Frame) {
            ID3v23Frame v23Frame = new ID3v23Frame(frame);
            this.createV24FrameFromV23Frame(v23Frame);
        }
        this.frameBody.setHeader(this);
    }

    public ID3v24Frame(Lyrics3v2Field field) throws InvalidTagException {
        String id = field.getIdentifier();
        if (id.equals("IND")) {
            throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 indications field.");
        }
        if (id.equals("LYR")) {
            FieldFrameBodyLYR lyric = (FieldFrameBodyLYR)field.getBody();
            Iterator<Lyrics3Line> iterator = lyric.iterator();
            boolean hasTimeStamp = lyric.hasTimeStamp();
            FrameBodySYLT sync = new FrameBodySYLT(0, "ENG", 2, 1, "", new byte[0]);
            FrameBodyUSLT unsync = new FrameBodyUSLT(0, "ENG", "", "");
            while (iterator.hasNext()) {
                Lyrics3Line line = iterator.next();
                if (hasTimeStamp) continue;
                unsync.addLyric(line);
            }
            if (hasTimeStamp) {
                this.frameBody = sync;
                this.frameBody.setHeader(this);
            } else {
                this.frameBody = unsync;
                this.frameBody.setHeader(this);
            }
        } else if (id.equals("INF")) {
            String value = ((FieldFrameBodyINF)field.getBody()).getAdditionalInformation();
            this.frameBody = new FrameBodyCOMM(0, "ENG", "", value);
            this.frameBody.setHeader(this);
        } else if (id.equals("AUT")) {
            String value = ((FieldFrameBodyAUT)field.getBody()).getAuthor();
            this.frameBody = new FrameBodyTCOM(0, value);
            this.frameBody.setHeader(this);
        } else if (id.equals("EAL")) {
            String value = ((FieldFrameBodyEAL)field.getBody()).getAlbum();
            this.frameBody = new FrameBodyTALB(0, value);
            this.frameBody.setHeader(this);
        } else if (id.equals("EAR")) {
            String value = ((FieldFrameBodyEAR)field.getBody()).getArtist();
            this.frameBody = new FrameBodyTPE1(0, value);
            this.frameBody.setHeader(this);
        } else if (id.equals("ETT")) {
            String value = ((FieldFrameBodyETT)field.getBody()).getTitle();
            this.frameBody = new FrameBodyTIT2(0, value);
            this.frameBody.setHeader(this);
        } else {
            if (id.equals("IMG")) {
                throw new InvalidTagException("Cannot create ID3v2.40 frame from Lyrics3 image field.");
            }
            throw new InvalidTagException("Cannot caret ID3v2.40 frame from " + id + " Lyrics3 field");
        }
    }

    public ID3v24Frame(ByteBuffer byteBuffer, String loggingFilename) throws InvalidFrameException, InvalidDataTypeException {
        this.setLoggingFilename(loggingFilename);
        this.read(byteBuffer);
    }

    public ID3v24Frame(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        this(byteBuffer, "");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ID3v24Frame)) {
            return false;
        }
        ID3v24Frame that = (ID3v24Frame)obj;
        return EqualsUtil.areEqual(this.statusFlags, that.statusFlags) && EqualsUtil.areEqual(this.encodingFlags, that.encodingFlags) && super.equals(that);
    }

    public int getSize() {
        return this.frameBody.getSize() + 10;
    }

    private void checkIfFrameSizeThatIsNotSyncSafe(ByteBuffer byteBuffer) throws InvalidFrameException {
        if (this.frameSize > 127) {
            int currentPosition = byteBuffer.position();
            byteBuffer.position(currentPosition - 4);
            int nonSyncSafeFrameSize = byteBuffer.getInt();
            byteBuffer.position(currentPosition - 4);
            boolean isNotSyncSafe = ID3SyncSafeInteger.isBufferNotSyncSafe(byteBuffer);
            byteBuffer.position(currentPosition);
            if (isNotSyncSafe) {
                logger.warning(this.getLoggingFilename() + ":" + "Frame size is NOT stored as a sync safe integer:" + this.identifier);
                if (nonSyncSafeFrameSize > byteBuffer.remaining() - -2) {
                    logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame size larger than size before mp3 audio:" + this.identifier);
                    throw new InvalidFrameException(this.identifier + " is invalid frame");
                }
                this.frameSize = nonSyncSafeFrameSize;
            } else {
                byte[] readAheadbuffer = new byte[4];
                byteBuffer.position(currentPosition + this.frameSize + 2);
                if (byteBuffer.remaining() < 4) {
                    byteBuffer.position(currentPosition);
                } else {
                    byteBuffer.get(readAheadbuffer, 0, 4);
                    byteBuffer.position(currentPosition);
                    String readAheadIdentifier = new String(readAheadbuffer);
                    if (!this.isValidID3v2FrameIdentifier(readAheadIdentifier) && !ID3SyncSafeInteger.isBufferEmpty(readAheadbuffer)) {
                        if (nonSyncSafeFrameSize > byteBuffer.remaining() - 2) {
                            byteBuffer.position(currentPosition);
                        } else {
                            readAheadbuffer = new byte[4];
                            byteBuffer.position(currentPosition + nonSyncSafeFrameSize + 2);
                            if (byteBuffer.remaining() >= 4) {
                                byteBuffer.get(readAheadbuffer, 0, 4);
                                readAheadIdentifier = new String(readAheadbuffer);
                                byteBuffer.position(currentPosition);
                                if (this.isValidID3v2FrameIdentifier(readAheadIdentifier)) {
                                    this.frameSize = nonSyncSafeFrameSize;
                                    logger.warning(this.getLoggingFilename() + ":" + "Assuming frame size is NOT stored as a sync safe integer:" + this.identifier);
                                } else if (ID3SyncSafeInteger.isBufferEmpty(readAheadbuffer)) {
                                    this.frameSize = nonSyncSafeFrameSize;
                                    logger.warning(this.getLoggingFilename() + ":" + "Assuming frame size is NOT stored as a sync safe integer:" + this.identifier);
                                }
                            } else {
                                byteBuffer.position(currentPosition);
                                if (byteBuffer.remaining() == 0) {
                                    this.frameSize = nonSyncSafeFrameSize;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void getFrameSize(ByteBuffer byteBuffer) throws InvalidFrameException {
        this.frameSize = ID3SyncSafeInteger.bufferToValue(byteBuffer);
        if (this.frameSize < 0) {
            logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame size:" + this.identifier);
            throw new InvalidFrameException(this.identifier + " is invalid frame");
        }
        if (this.frameSize == 0) {
            logger.warning(this.getLoggingFilename() + ":" + "Empty Frame:" + this.identifier);
            byteBuffer.get();
            byteBuffer.get();
            throw new EmptyFrameException(this.identifier + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining() - 2) {
            logger.warning(this.getLoggingFilename() + ":" + "Invalid Frame size larger than size before mp3 audio:" + this.identifier);
            throw new InvalidFrameException(this.identifier + " is invalid frame");
        }
        this.checkIfFrameSizeThatIsNotSyncSafe(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        byte[] buffer = new byte[4];
        if (byteBuffer.position() + 10 >= byteBuffer.limit()) {
            logger.warning(this.getLoggingFilename() + ":" + "No space to find another frame:");
            throw new InvalidFrameException(this.getLoggingFilename() + ":" + "No space to find another frame");
        }
        byteBuffer.get(buffer, 0, 4);
        this.identifier = new String(buffer);
        logger.fine(this.getLoggingFilename() + ":" + "Identifier is" + this.identifier);
        if (!this.isValidID3v2FrameIdentifier(this.identifier)) {
            logger.info(this.getLoggingFilename() + ":" + "Invalid identifier:" + this.identifier);
            byteBuffer.position(byteBuffer.position() - 3);
            throw new InvalidFrameIdentifierException(this.identifier + " is not a valid ID3v2.40 frame");
        }
        this.getFrameSize(byteBuffer);
        this.statusFlags = new StatusFlags(byteBuffer.get());
        this.encodingFlags = new EncodingFlags(byteBuffer.get());
        int extraHeaderBytesCount = 0;
        int dataLengthSize = -1;
        if (((EncodingFlags)this.encodingFlags).isGrouping()) {
            extraHeaderBytesCount = 1;
            this.groupIdentifier = byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isEncryption()) {
            ++extraHeaderBytesCount;
            this.encryptionMethod = byteBuffer.get();
        }
        if (((EncodingFlags)this.encodingFlags).isDataLengthIndicator()) {
            dataLengthSize = ID3SyncSafeInteger.bufferToValue(byteBuffer);
            extraHeaderBytesCount += 4;
            logger.info(this.getLoggingFilename() + ":" + "Frame Size Is:" + this.frameSize + " Data Length Size:" + dataLengthSize);
        }
        int realFrameSize = this.frameSize - extraHeaderBytesCount;
        ByteBuffer frameBodyBuffer = byteBuffer.slice();
        frameBodyBuffer.limit(realFrameSize);
        int syncSize = realFrameSize;
        if (((EncodingFlags)this.encodingFlags).isUnsynchronised()) {
            frameBodyBuffer = ID3Unsynchronization.synchronize(frameBodyBuffer);
            syncSize = frameBodyBuffer.limit();
            logger.info(this.getLoggingFilename() + ":" + "Frame Size After Syncing is:" + syncSize);
        }
        try {
            if (((EncodingFlags)this.encodingFlags).isCompression()) {
                frameBodyBuffer = ID3Compression.uncompress(this.identifier, this.getLoggingFilename(), byteBuffer, dataLengthSize, realFrameSize);
                this.frameBody = this.readBody(this.identifier, frameBodyBuffer, dataLengthSize);
            } else if (((EncodingFlags)this.encodingFlags).isEncryption()) {
                frameBodyBuffer = byteBuffer.slice();
                frameBodyBuffer.limit(realFrameSize);
                this.frameBody = this.readEncryptedBody(this.identifier, byteBuffer, this.frameSize);
            } else {
                this.frameBody = this.readBody(this.identifier, frameBodyBuffer, syncSize);
            }
            if (!(this.frameBody instanceof ID3v24FrameBody)) {
                logger.info(this.getLoggingFilename() + ":" + "Converted frame body with:" + this.identifier + " to deprecated framebody");
                this.frameBody = new FrameBodyDeprecated((AbstractID3v2FrameBody)this.frameBody);
            }
        }
        finally {
            byteBuffer.position(byteBuffer.position() + realFrameSize);
        }
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        boolean unsynchronization;
        logger.info("Writing frame to file:" + this.getIdentifier());
        ByteBuffer headerBuffer = ByteBuffer.allocate(10);
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(bodyOutputStream);
        byte[] bodyBuffer = bodyOutputStream.toByteArray();
        boolean bl = unsynchronization = TagOptionSingleton.getInstance().isUnsyncTags() && ID3Unsynchronization.requiresUnsynchronization(bodyBuffer);
        if (unsynchronization) {
            bodyBuffer = ID3Unsynchronization.unsynchronize(bodyBuffer);
            logger.info("bodybytebuffer:sizeafterunsynchronisation:" + bodyBuffer.length);
        }
        if (this.getIdentifier().length() == 3) {
            this.identifier = this.identifier + ' ';
        }
        headerBuffer.put(Utils.getDefaultBytes(this.getIdentifier(), "ISO-8859-1"), 0, 4);
        int size = bodyBuffer.length;
        logger.fine("Frame Size Is:" + size);
        headerBuffer.put(ID3SyncSafeInteger.valueToBuffer(size));
        headerBuffer.put(this.statusFlags.getWriteFlags());
        if (unsynchronization) {
            ((EncodingFlags)this.encodingFlags).setUnsynchronised();
        } else {
            ((EncodingFlags)this.encodingFlags).unsetUnsynchronised();
        }
        ((EncodingFlags)this.encodingFlags).unsetCompression();
        ((EncodingFlags)this.encodingFlags).unsetDataLengthIndicator();
        headerBuffer.put(this.encodingFlags.getFlags());
        try {
            tagBuffer.write(headerBuffer.array());
            if (((EncodingFlags)this.encodingFlags).isEncryption()) {
                tagBuffer.write(this.encryptionMethod);
            }
            if (((EncodingFlags)this.encodingFlags).isGrouping()) {
                tagBuffer.write(this.groupIdentifier);
            }
            tagBuffer.write(bodyBuffer);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public AbstractID3v2Frame.StatusFlags getStatusFlags() {
        return this.statusFlags;
    }

    public AbstractID3v2Frame.EncodingFlags getEncodingFlags() {
        return this.encodingFlags;
    }

    public int getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public int getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public boolean isValidID3v2FrameIdentifier(String identifier) {
        Matcher m = validFrameIdentifier.matcher(identifier);
        return m.matches();
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.statusFlags.createStructure();
        this.encodingFlags.createStructure();
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    public boolean isCommon() {
        return ID3v24Frames.getInstanceOf().isCommon(this.getId());
    }

    public boolean isBinary() {
        return ID3v24Frames.getInstanceOf().isBinary(this.getId());
    }

    public void setEncoding(String encoding) {
        Integer encodingId = TextEncoding.getInstanceOf().getIdForValue(encoding);
        if (encoding != null && encodingId < 4) {
            this.getBody().setTextEncoding(encodingId.byteValue());
        }
    }

    class EncodingFlags
    extends AbstractID3v2Frame.EncodingFlags {
        public static final String TYPE_COMPRESSION = "compression";
        public static final String TYPE_ENCRYPTION = "encryption";
        public static final String TYPE_GROUPIDENTITY = "groupidentity";
        public static final String TYPE_FRAMEUNSYNCHRONIZATION = "frameUnsynchronisation";
        public static final String TYPE_DATALENGTHINDICATOR = "dataLengthIndicator";
        public static final int MASK_GROUPING_IDENTITY = 64;
        public static final int MASK_COMPRESSION = 8;
        public static final int MASK_ENCRYPTION = 4;
        public static final int MASK_FRAME_UNSYNCHRONIZATION = 2;
        public static final int MASK_DATA_LENGTH_INDICATOR = 1;

        EncodingFlags() {
        }

        EncodingFlags(byte flags) {
            super(flags);
            this.logEnabledFlags();
        }

        public void logEnabledFlags() {
            if (this.isCompression()) {
                AbstractTagItem.logger.warning(ErrorMessage.MP3_FRAME_IS_COMPRESSED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isEncryption()) {
                AbstractTagItem.logger.warning(ErrorMessage.MP3_FRAME_IS_ENCRYPTED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isGrouping()) {
                AbstractTagItem.logger.info(ErrorMessage.MP3_FRAME_IS_GROUPED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isUnsynchronised()) {
                AbstractTagItem.logger.info(ErrorMessage.MP3_FRAME_IS_UNSYNCHRONISED.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
            if (this.isDataLengthIndicator()) {
                AbstractTagItem.logger.info(ErrorMessage.MP3_FRAME_IS_DATA_LENGTH_INDICATOR.getMsg(ID3v24Frame.this.getLoggingFilename(), ID3v24Frame.this.identifier));
            }
        }

        public byte getFlags() {
            return this.flags;
        }

        public boolean isCompression() {
            return (this.flags & 8) > 0;
        }

        public boolean isEncryption() {
            return (this.flags & 4) > 0;
        }

        public boolean isGrouping() {
            return (this.flags & 0x40) > 0;
        }

        public boolean isUnsynchronised() {
            return (this.flags & 2) > 0;
        }

        public boolean isDataLengthIndicator() {
            return (this.flags & 1) > 0;
        }

        public void setCompression() {
            this.flags = (byte)(this.flags | 8);
        }

        public void setEncryption() {
            this.flags = (byte)(this.flags | 4);
        }

        public void setGrouping() {
            this.flags = (byte)(this.flags | 0x40);
        }

        public void setUnsynchronised() {
            this.flags = (byte)(this.flags | 2);
        }

        public void setDataLengthIndicator() {
            this.flags = (byte)(this.flags | 1);
        }

        public void unsetCompression() {
            this.flags = (byte)(this.flags & 0xFFFFFFF7);
        }

        public void unsetEncryption() {
            this.flags = (byte)(this.flags & 0xFFFFFFFB);
        }

        public void unsetGrouping() {
            this.flags = (byte)(this.flags & 0xFFFFFFBF);
        }

        public void unsetUnsynchronised() {
            this.flags = (byte)(this.flags & 0xFFFFFFFD);
        }

        public void unsetDataLengthIndicator() {
            this.flags = (byte)(this.flags & 0xFFFFFFFE);
        }

        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("encodingFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_COMPRESSION, this.flags & 8);
            MP3File.getStructureFormatter().addElement(TYPE_ENCRYPTION, this.flags & 4);
            MP3File.getStructureFormatter().addElement(TYPE_GROUPIDENTITY, this.flags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_FRAMEUNSYNCHRONIZATION, this.flags & 2);
            MP3File.getStructureFormatter().addElement(TYPE_DATALENGTHINDICATOR, this.flags & 1);
            MP3File.getStructureFormatter().closeHeadingElement("encodingFlags");
        }
    }

    class StatusFlags
    extends AbstractID3v2Frame.StatusFlags {
        public static final String TYPE_TAGALTERPRESERVATION = "typeTagAlterPreservation";
        public static final String TYPE_FILEALTERPRESERVATION = "typeFileAlterPreservation";
        public static final String TYPE_READONLY = "typeReadOnly";
        public static final int MASK_TAG_ALTER_PRESERVATION = 64;
        public static final int MASK_FILE_ALTER_PRESERVATION = 32;
        public static final int MASK_READ_ONLY = 16;

        StatusFlags() {
        }

        StatusFlags(byte flags) {
            this.originalFlags = flags;
            this.writeFlags = flags;
            this.modifyFlags();
        }

        StatusFlags(ID3v23Frame.StatusFlags statusFlags) {
            this.writeFlags = this.originalFlags = this.convertV3ToV4Flags(statusFlags.getOriginalFlags());
            this.modifyFlags();
        }

        private byte convertV3ToV4Flags(byte v3Flag) {
            byte v4Flag = 0;
            if ((v3Flag & 0x40) != 0) {
                v4Flag = (byte)(v4Flag | 0x20);
            }
            if ((v3Flag & 0x80) != 0) {
                v4Flag = (byte)(v4Flag | 0x40);
            }
            return v4Flag;
        }

        protected void modifyFlags() {
            String str = ID3v24Frame.this.getIdentifier();
            if (ID3v24Frames.getInstanceOf().isDiscardIfFileAltered(str)) {
                this.writeFlags = (byte)(this.writeFlags | 0x20);
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFBF);
            } else {
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFDF);
                this.writeFlags = (byte)(this.writeFlags & 0xFFFFFFBF);
            }
        }

        public void createStructure() {
            MP3File.getStructureFormatter().openHeadingElement("statusFlags", "");
            MP3File.getStructureFormatter().addElement(TYPE_TAGALTERPRESERVATION, this.originalFlags & 0x40);
            MP3File.getStructureFormatter().addElement(TYPE_FILEALTERPRESERVATION, this.originalFlags & 0x20);
            MP3File.getStructureFormatter().addElement(TYPE_READONLY, this.originalFlags & 0x10);
            MP3File.getStructureFormatter().closeHeadingElement("statusFlags");
        }
    }
}

