/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.tag.EmptyFrameException;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.InvalidFrameIdentifierException;
import org.jaudiotagger.tag.id3.AbstractID3v2Frame;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v22Frames;
import org.jaudiotagger.tag.id3.ID3v23Frame;
import org.jaudiotagger.tag.id3.ID3v24Frame;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyDeprecated;
import org.jaudiotagger.tag.id3.framebody.FrameBodyUnsupported;
import org.jaudiotagger.tag.id3.valuepair.TextEncoding;
import org.jaudiotagger.utils.EqualsUtil;

public class ID3v22Frame
extends AbstractID3v2Frame {
    private static Pattern validFrameIdentifier = Pattern.compile("[A-Z][0-9A-Z]{2}");
    protected static final int FRAME_ID_SIZE = 3;
    protected static final int FRAME_SIZE_SIZE = 3;
    protected static final int FRAME_HEADER_SIZE = 6;

    public ID3v22Frame() {
    }

    public ID3v22Frame(AbstractID3v2FrameBody body) {
        super(body);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ID3v22Frame)) {
            return false;
        }
        ID3v22Frame that = (ID3v22Frame)obj;
        return EqualsUtil.areEqual(this.statusFlags, that.statusFlags) && EqualsUtil.areEqual(this.encodingFlags, that.encodingFlags) && super.equals(that);
    }

    public ID3v22Frame(String identifier) {
        logger.info("Creating empty frame of type" + identifier);
        String bodyIdentifier = identifier;
        this.identifier = identifier;
        if (ID3Tags.isID3v22FrameIdentifier(bodyIdentifier) && ID3Tags.forceFrameID22To23(bodyIdentifier) == null && !bodyIdentifier.equals("CRM")) {
            if (bodyIdentifier.equals("TYE") || bodyIdentifier.equals("TIM")) {
                bodyIdentifier = "TDRC";
            } else if (ID3Tags.isID3v22FrameIdentifier(bodyIdentifier)) {
                bodyIdentifier = ID3Tags.convertFrameID22To23(bodyIdentifier);
            }
        }
        try {
            Class<?> c = Class.forName("org.jaudiotagger.tag.id3.framebody.FrameBody" + bodyIdentifier);
            this.frameBody = (AbstractTagFrameBody)c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            logger.log(Level.SEVERE, cnfe.getMessage(), cnfe);
            this.frameBody = new FrameBodyUnsupported(identifier);
        }
        catch (InstantiationException ie) {
            logger.log(Level.SEVERE, ie.getMessage(), ie);
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            logger.log(Level.SEVERE, iae.getMessage(), iae);
            throw new RuntimeException(iae);
        }
        this.frameBody.setHeader(this);
        logger.info("Created empty frame of type" + this.identifier + "with frame body of" + bodyIdentifier);
    }

    public ID3v22Frame(ID3v22Frame frame) {
        super(frame);
        logger.info("Creating frame from a frame of same version");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createV22FrameFromV23Frame(ID3v23Frame frame) throws InvalidFrameException {
        this.identifier = ID3Tags.convertFrameID23To22(frame.getIdentifier());
        if (this.identifier != null) {
            logger.info("V2:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
            this.frameBody = (AbstractID3v2FrameBody)ID3Tags.copyObject(frame.getBody());
            return;
        } else if (ID3Tags.isID3v23FrameIdentifier(frame.getIdentifier())) {
            this.identifier = ID3Tags.forceFrameID23To22(frame.getIdentifier());
            if (this.identifier == null) throw new InvalidFrameException("Unable to convert v23 frame:" + frame.getIdentifier() + " to a v22 frame");
            logger.info("V2:Force:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
            this.frameBody = this.readBody(this.identifier, (AbstractID3v2FrameBody)frame.getBody());
            return;
        } else if (frame.getBody() instanceof FrameBodyDeprecated) {
            if (ID3Tags.isID3v22FrameIdentifier(frame.getIdentifier())) {
                this.frameBody = frame.getBody();
                this.identifier = frame.getIdentifier();
                logger.info("DEPRECATED:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
                return;
            } else {
                this.frameBody = new FrameBodyDeprecated((FrameBodyDeprecated)frame.getBody());
                this.identifier = frame.getIdentifier();
                logger.info("DEPRECATED:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
            }
            return;
        } else {
            this.frameBody = new FrameBodyUnsupported((FrameBodyUnsupported)frame.getBody());
            this.identifier = frame.getIdentifier();
            logger.info("v2:UNKNOWN:Orig id is:" + frame.getIdentifier() + ":New id is:" + this.identifier);
        }
    }

    public ID3v22Frame(AbstractID3v2Frame frame) throws InvalidFrameException {
        logger.info("Creating frame from a frame of a different version");
        if (frame instanceof ID3v22Frame) {
            throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
        }
        if (frame instanceof ID3v24Frame) {
            ID3v23Frame v23Frame = new ID3v23Frame(frame);
            this.createV22FrameFromV23Frame(v23Frame);
        } else if (frame instanceof ID3v23Frame) {
            this.createV22FrameFromV23Frame((ID3v23Frame)frame);
        }
        this.frameBody.setHeader(this);
        logger.info("Created frame from a frame of a different version");
    }

    public ID3v22Frame(ByteBuffer byteBuffer, String loggingFilename) throws InvalidFrameException, InvalidDataTypeException {
        this.setLoggingFilename(loggingFilename);
        this.read(byteBuffer);
    }

    public ID3v22Frame(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        this(byteBuffer, "");
    }

    public int getSize() {
        return this.frameBody.getSize() + 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ByteBuffer byteBuffer) throws InvalidFrameException, InvalidDataTypeException {
        byte[] buffer = new byte[3];
        if (byteBuffer.position() + 6 >= byteBuffer.limit()) {
            logger.warning("No space to find another frame:");
            throw new InvalidFrameException(" No space to find another frame");
        }
        byteBuffer.get(buffer, 0, 3);
        this.identifier = new String(buffer);
        logger.info("Read Frame from file identifier is:" + this.identifier);
        if (!this.isValidID3v2FrameIdentifier(this.identifier)) {
            logger.info("Invalid identifier:" + this.identifier);
            byteBuffer.position(byteBuffer.position() - 2);
            throw new InvalidFrameIdentifierException(this.identifier + " is not a valid ID3v2.20 frame");
        }
        byteBuffer.get(buffer, 0, 3);
        this.frameSize = this.decodeSize(buffer);
        if (this.frameSize < 0) {
            throw new InvalidFrameException(this.identifier + " has invalid size of:" + this.frameSize);
        }
        if (this.frameSize == 0) {
            logger.warning("Empty Frame:" + this.identifier);
            throw new EmptyFrameException(this.identifier + " is empty frame");
        }
        if (this.frameSize > byteBuffer.remaining()) {
            logger.warning("Invalid Frame size larger than size before mp3 audio:" + this.identifier);
            throw new InvalidFrameException(this.identifier + " is invalid frame");
        }
        logger.fine("Frame Size Is:" + this.frameSize);
        String id = ID3Tags.convertFrameID22To24(this.identifier);
        if (id == null && (id = ID3Tags.convertFrameID22To23(this.identifier)) == null) {
            id = ID3Tags.isID3v22FrameIdentifier(this.identifier) ? this.identifier : "Unsupported";
        }
        logger.fine("Identifier was:" + this.identifier + " reading using:" + id);
        ByteBuffer frameBodyBuffer = byteBuffer.slice();
        frameBodyBuffer.limit(this.frameSize);
        try {
            this.frameBody = this.readBody(id, frameBodyBuffer, this.frameSize);
        }
        finally {
            byteBuffer.position(byteBuffer.position() + this.frameSize);
        }
    }

    private int decodeSize(byte[] buffer) {
        BigInteger bi = new BigInteger(buffer);
        int tmpSize = bi.intValue();
        if (tmpSize < 0) {
            logger.warning("Invalid Frame Size of:" + tmpSize + "Decoded from bin:" + Integer.toBinaryString(tmpSize) + "Decoded from hex:" + Integer.toHexString(tmpSize));
        }
        return tmpSize;
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        logger.info("Write Frame to Buffer" + this.getIdentifier());
        ByteBuffer headerBuffer = ByteBuffer.allocate(6);
        ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
        ((AbstractID3v2FrameBody)this.frameBody).write(bodyOutputStream);
        headerBuffer.put(Utils.getDefaultBytes(this.getIdentifier(), "ISO-8859-1"), 0, 3);
        this.encodeSize(headerBuffer, this.frameBody.getSize());
        try {
            tagBuffer.write(headerBuffer.array());
            tagBuffer.write(bodyOutputStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void encodeSize(ByteBuffer headerBuffer, int size) {
        headerBuffer.put((byte)((size & 0xFF0000) >> 16));
        headerBuffer.put((byte)((size & 0xFF00) >> 8));
        headerBuffer.put((byte)(size & 0xFF));
        logger.fine("Frame Size Is Actual:" + size + ":Encoded bin:" + Integer.toBinaryString(size) + ":Encoded Hex" + Integer.toHexString(size));
    }

    public boolean isValidID3v2FrameIdentifier(String identifier) {
        Matcher m = validFrameIdentifier.matcher(identifier);
        return m.matches();
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("frame", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("frameSize", this.frameSize);
        this.frameBody.createStructure();
        MP3File.getStructureFormatter().closeHeadingElement("frame");
    }

    public boolean isCommon() {
        return ID3v22Frames.getInstanceOf().isCommon(this.getId());
    }

    public boolean isBinary() {
        return ID3v22Frames.getInstanceOf().isBinary(this.getId());
    }

    public void setEncoding(String encoding) {
        Integer encodingId = TextEncoding.getInstanceOf().getIdForValue(encoding);
        if (encoding != null && encodingId < 2) {
            this.getBody().setTextEncoding(encodingId.byteValue());
        }
    }
}

