/*__________________________________________________________________________

	memchr           memchr c-string function
						
    Copyright (C) 2003 jan schacher
    
    thanks to tim place for inspiration and sample code

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
    
    initial build 200300505
    
____________________________________________________________________________*/

#include "m_pd.h"
#include <string.h>
#define MIN(a,b) ((a)<(b)?(a):(b))



typedef struct memchr 		
{
	t_object		ob;		
	void 			*s_outlet;	
	char 			s_tempstring[4096];
	long			s_numChar;
} t_memchr;

void *memchr_class;
void *memchr_new(t_symbol *s, long argc, t_atom *argv);
void memchr_free(t_memchr *x);
void memchr_float(t_memchr *x, float f);
void memchr_anything(t_memchr *x, t_symbol *s, long argc, t_atom *argv);
void memchr_set(t_memchr *x, t_symbol *s, long argc, t_atom *argv);

void memchr_setup(void)
{	
	memchr_class = class_new(gensym("memchr"), (t_newmethod)memchr_new, (t_method)memchr_free, sizeof(t_memchr), 0, A_GIMME, 0);
	class_addfloat(memchr_class, (t_method)memchr_float);
	class_addsymbol(memchr_class, (t_method)memchr_anything);
	class_addmethod(memchr_class, (t_method)memchr_set,		gensym("set"),	A_GIMME, 0);
	post(".    memchr    .    jasch    .    "__DATE__" ",0);
}

void *memchr_new(t_symbol *s, long argc, t_atom *argv)
{
	short i;
	t_memchr	*x;
	x = (t_memchr *)pd_new(memchr_class);
	x->s_outlet = outlet_new(&x->ob, gensym("float"));	
	strcpy(x->s_tempstring, "/");
	x->s_numChar = 1024;
	for(i=0; i<argc; i++){
		switch(argv[i].a_type){
		case A_FLOAT:
			if(i == 1){
			x->s_numChar = argv[1].a_w.w_float;
			}
		break;
		case A_SYMBOL:
			if(i == 0){
			strncpy(x->s_tempstring, argv[0].a_w.w_symbol->s_name, 1);
			}
		break;
		}
	}
	return (x);									
}

void memchr_assist(t_memchr *x, void *b, long msg, long arg, char *dst)
{
	if(msg==1) 	
		switch(arg){
			case 0: strcpy(dst, "strings in (symbol)"); break;
			}
	else if(msg==2){ 				
		 strcpy(dst, "matched positions (int)");	
 	}		
}

void memchr_float(t_memchr *x, float f)
{
	x->s_numChar = (long)f;
}

void memchr_anything(t_memchr *x, t_symbol *s, long argc, t_atom *argv)
{
	char	*ptr;
	char	local[4096];
	long	pos;
	strcpy(local, s->s_name);
	ptr = (char*)memchr(local, x->s_tempstring[0], MIN((long)strlen(local), x->s_numChar));
	if(ptr != NULL){
   	pos = (long)(ptr-local+1);
   		outlet_float(x->s_outlet, pos); 
   		}else{
   		outlet_float(x->s_outlet,-1); 
   	}
	return;
}

void memchr_set(t_memchr *x, t_symbol *s, long argc, t_atom *argv)
{
	if(argc >= 1){
	switch (argv[0].a_type) {
		case A_FLOAT: error("memchr: wrong argument type for set");break;
		case A_SYMBOL: 
			strncpy(x->s_tempstring, argv[0].a_w.w_symbol->s_name, 1);
			x->s_tempstring[1] = 0;
		break;
	}
	}
}

void memchr_free(t_memchr *x)
{
		// notify_free((t_object *)x);
}