/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.File;
import java.util.Vector;
import music.cpp.client.Engine;
import music.cpp.client.NativeEngine;
import music.cpp.client.Song;

public class UserPlaylist {
    File file;
    private long id;

    public UserPlaylist(String string, long l) {
        this.file = string == null ? null : new File(string);
        this.id = l;
    }

    public String toString() {
        return this.getName();
    }

    public long getID() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof UserPlaylist)) {
            return false;
        }
        return this.id == ((UserPlaylist)object).id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void reset() {
        this.id = 0L;
    }

    public void setDirty(boolean bl) {
        this.setDirty(this.id, bl);
    }

    public boolean isDirty() {
        return this.isDirty(this.id);
    }

    public void setName(String string) {
        this.setName(this.id, string);
    }

    public String getName() {
        return this.getName(this.id);
    }

    public void add(String string) {
        this.add(this.id, string);
    }

    public void add(Song song) {
        this.add(this.id, song.getID());
    }

    public void removeSong(Song song) {
        this.removeSong(this.id, song.getID());
    }

    public void removePointer(Song song) {
        this.removePointer(this.id, song.getID());
    }

    public void clear() {
        this.clear(this.id);
    }

    public boolean isLoaded() {
        return this.isLoaded(this.id);
    }

    public void setLoaded(boolean bl) {
        this.setLoaded(this.id, bl);
    }

    public Vector getSongs(Engine engine) {
        return this.getSongs(this.id, ((NativeEngine)engine).getID());
    }

    public boolean contains(Song song) {
        return this.contains(this.id, song.getID());
    }

    public void update(Vector vector) {
        this.update(this.id, vector);
    }

    public void unload() {
        this.unload(this.id);
    }

    public boolean isRelative() {
        return this.isRelative(this.id);
    }

    public void setRelative(boolean bl) {
        this.setRelative(this.id, bl);
    }

    public boolean isExtended() {
        return this.isExtended(this.id);
    }

    public void setExtended(boolean bl) {
        this.setExtended(this.id, bl);
    }

    private native void setDirty(long var1, boolean var3);

    private native boolean isDirty(long var1);

    private native void setName(long var1, String var3);

    private native String getName(long var1);

    private native void add(long var1, String var3);

    private native void add(long var1, long var3);

    private native void removeSong(long var1, long var3);

    private native void removePointer(long var1, long var3);

    private native void clear(long var1);

    private native Vector getSongs(long var1, long var3);

    private native boolean contains(long var1, long var3);

    private native void update(long var1, Vector var3);

    private native void unload(long var1);

    private native boolean isLoaded(long var1);

    private native void setLoaded(long var1, boolean var3);

    private native boolean isRelative(long var1);

    private native void setRelative(long var1, boolean var3);

    private native boolean isExtended(long var1);

    private native void setExtended(long var1, boolean var3);
}

