/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import music.cpp.client.MusicClient;
import music.cpp.client.Opt;
import music.cpp.client.Sorter;
import music.cpp.client.VectorUtil;

public class TableConfigurationPanel
extends JPanel {
    static final String iAdd = MusicClient.STRINGS.get("IDSTR_PV_ADD");
    static final String iRemove = MusicClient.STRINGS.get("IDSTR_PV_REMOVE");
    static final String iUp = MusicClient.STRINGS.get("IDSTR_PV_UP");
    static final String iDown = MusicClient.STRINGS.get("IDSTR_PV_DOWN");
    static final String iAvailableColumns = MusicClient.STRINGS.get("IDSTR_PV_AVAILABLE");
    static final String iSelectedColumns = MusicClient.STRINGS.get("IDSTR_PV_SELECTED");
    MusicClient client;
    DefaultListModel optionsModel;
    DefaultListModel toolbarModel;
    JList options;
    JList toolbar;
    JButton add;
    JButton remove;
    JButton up;
    JButton down;
    Vector actions;

    public TableConfigurationPanel(MusicClient musicClient) {
        super(new GridBagLayout());
        this.client = musicClient;
        this.actions = new Vector();
        int n = 0;
        while (true) {
            if (n >= MusicClient.fields.length) break;
            if (n != 11 && n != 12 && n != 13 && n != 20 && n != 21 && n != 22 && n != 24 && n != 25 && n != 26 && n != 27) {
                this.actions.add(new Opt(MusicClient.fields[n], n));
            }
            ++n;
        }
        VectorUtil.sort(this.actions, new Sorter(){

            public int compare(Object object, Object object2) {
                return object.toString().compareToIgnoreCase(object2.toString());
            }
        });
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.optionsModel = new DefaultListModel();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.options = this.client.createList(jPanel, this.optionsModel, iAvailableColumns, false);
        this.options.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (TableConfigurationPanel.this.options.getSelectedIndices().length == 1) {
                    TableConfigurationPanel.this.add.setEnabled(true);
                } else {
                    TableConfigurationPanel.this.add.setEnabled(false);
                }
            }
        });
        this.options.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && TableConfigurationPanel.this.options.locationToIndex(mouseEvent.getPoint()) >= 0) {
                    TableConfigurationPanel.this.addItem();
                }
            }
        });
        this.options.setSelectionMode(0);
        jPanel.setOpaque(false);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.up = new JButton(iUp);
        this.up.setMnemonic('u');
        this.up.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableConfigurationPanel.this.toolbar.getSelectedIndex();
                Object e = TableConfigurationPanel.this.toolbarModel.elementAt(n - 1);
                Object e2 = TableConfigurationPanel.this.toolbarModel.elementAt(n);
                TableConfigurationPanel.this.toolbarModel.setElementAt(e2, n - 1);
                TableConfigurationPanel.this.toolbarModel.setElementAt(e, n);
                TableConfigurationPanel.this.toolbar.setSelectedIndex(n - 1);
                TableConfigurationPanel.this.toolbar.ensureIndexIsVisible(n - 1);
            }
        });
        this.up.setEnabled(false);
        this.down = new JButton(iDown);
        this.down.setMnemonic('d');
        this.down.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = TableConfigurationPanel.this.toolbar.getSelectedIndex();
                Object e = TableConfigurationPanel.this.toolbarModel.elementAt(n);
                Object e2 = TableConfigurationPanel.this.toolbarModel.elementAt(n + 1);
                TableConfigurationPanel.this.toolbarModel.setElementAt(e2, n);
                TableConfigurationPanel.this.toolbarModel.setElementAt(e, n + 1);
                TableConfigurationPanel.this.toolbar.setSelectedIndex(n + 1);
                TableConfigurationPanel.this.toolbar.ensureIndexIsVisible(n + 1);
            }
        });
        this.down.setEnabled(false);
        this.add = new JButton(iAdd);
        this.add.setMnemonic('a');
        this.add.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConfigurationPanel.this.addItem();
            }
        });
        this.add.setEnabled(false);
        this.remove = new JButton(iRemove);
        this.remove.setMnemonic('r');
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableConfigurationPanel.this.removeItem();
            }
        });
        this.remove.setEnabled(false);
        JPanel jPanel2 = new JPanel(new GridLayout(4, 1, 0, 5));
        jPanel2.setOpaque(false);
        jPanel2.add(this.add);
        jPanel2.add(this.remove);
        jPanel2.add(this.up);
        jPanel2.add(this.down);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.toolbarModel = new DefaultListModel();
        int n2 = 0;
        while (true) {
            if (n2 >= MusicClient.order.length) break;
            for (int i = 0; i < this.actions.size(); ++i) {
                Opt opt = (Opt)this.actions.elementAt(i);
                if (opt.index != MusicClient.order[n2]) continue;
                this.toolbarModel.addElement(opt);
                break;
            }
            ++n2;
        }
        JPanel jPanel3 = new JPanel(new BorderLayout());
        this.toolbar = this.client.createList(jPanel3, this.toolbarModel, iSelectedColumns, false);
        this.toolbar.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                if (TableConfigurationPanel.this.toolbar.getSelectedIndices().length == 1) {
                    int n = TableConfigurationPanel.this.toolbar.getSelectedIndex();
                    TableConfigurationPanel.this.up.setEnabled(n > 0);
                    TableConfigurationPanel.this.down.setEnabled(n < TableConfigurationPanel.this.toolbarModel.size() - 1);
                    TableConfigurationPanel.this.remove.setEnabled(true);
                } else {
                    TableConfigurationPanel.this.up.setEnabled(false);
                    TableConfigurationPanel.this.down.setEnabled(false);
                    TableConfigurationPanel.this.remove.setEnabled(false);
                }
            }
        });
        this.toolbar.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && TableConfigurationPanel.this.toolbar.locationToIndex(mouseEvent.getPoint()) >= 0) {
                    TableConfigurationPanel.this.removeItem();
                }
            }
        });
        this.toolbar.setSelectionMode(0);
        jPanel3.setOpaque(false);
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.add(jPanel3);
        this.setOpaque(false);
        this.updateAll();
    }

    void addItem() {
        int n = this.options.getSelectedIndex();
        Opt opt = (Opt)this.optionsModel.elementAt(n);
        int n2 = this.toolbar.getSelectedIndex();
        if (n2 < 0) {
            this.toolbarModel.addElement(opt);
            n2 = this.toolbarModel.size() - 1;
        } else {
            this.toolbarModel.insertElementAt(opt, n2 + 1);
            ++n2;
        }
        this.toolbar.setSelectedIndex(n2);
        this.toolbar.ensureIndexIsVisible(n2);
        this.updateAll();
    }

    void removeItem() {
        int n = this.toolbar.getSelectedIndex();
        Opt opt = (Opt)this.toolbarModel.getElementAt(n);
        this.toolbarModel.removeElementAt(n);
        this.updateAll();
        n = this.optionsModel.indexOf(opt);
        if (n >= 0) {
            this.options.setSelectedIndex(n);
            this.options.ensureIndexIsVisible(n);
        }
    }

    void updateAll() {
        this.optionsModel.clear();
        Iterator iterator = this.actions.iterator();
        while (iterator.hasNext()) {
            Opt opt = (Opt)iterator.next();
            boolean bl = false;
            for (int i = 0; i < this.toolbarModel.size(); ++i) {
                if (!opt.equals(this.toolbarModel.elementAt(i))) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            this.optionsModel.addElement(opt);
        }
    }

    public void apply() {
        int[] nArray = new int[this.toolbarModel.size()];
        Enumeration enumeration = this.toolbarModel.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Opt opt = (Opt)enumeration.nextElement();
            nArray[n++] = opt.index;
        }
        this.client.resetTable(nArray, true);
    }
}

