/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import music.cpp.client.DialogUtil;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;
import music.cpp.client.Skin;
import music.cpp.client.Song;

public class SongInfoDialog
extends JDialog {
    public SongInfoDialog(final MusicClient musicClient, Song song) {
        super(musicClient, song.name(), true);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                musicClient.enableMenus(true);
            }
        });
        JTextArea jTextArea = new JTextArea(){

            protected void paintComponent(Graphics graphics) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                super.paintComponent(graphics);
            }
        };
        jTextArea.setFont(new Label2().getFont());
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setText(MusicClient.STRINGS.expand("IDSTR_SI_TITLE", new String[]{song.name()}) + "\n" + MusicClient.STRINGS.expand("IDSTR_SI_ARTIST", new String[]{song.artist().name()}) + "\n" + MusicClient.STRINGS.expand("IDSTR_SI_ALBUM", new String[]{song.album().name()}) + "\n" + MusicClient.STRINGS.expand("IDSTR_SI_FILE", new String[]{song.mp3().getAbsolutePath()}));
        jPanel.add("Center", jTextArea);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        JButton jButton = new JButton(MusicClient.iOK);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SongInfoDialog.this.dispose();
                musicClient.enableMenus(true);
            }
        });
        jPanel2.add(jButton);
        this.getRootPane().setDefaultButton(jButton);
        jPanel.add("South", jPanel2);
        this.getContentPane().add(jPanel);
        jPanel.setBorder(new EmptyBorder(Skin.getSkin().infoInsets));
        this.pack();
        DialogUtil.centerDialog(musicClient, this);
        this.setResizable(false);
        this.setVisible(true);
    }
}

