/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import music.cpp.client.ClipboardUtil;
import music.cpp.client.DialogUtil;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeEngine;
import music.cpp.client.RegistrationDialog;
import music.cpp.client.Skin;
import music.cpp.client.StringUtil;

class RegistrationDialog
extends JDialog {
    static final String iTrial = MusicClient.STRINGS.get("IDSTR_TRIAL");
    static final String iMsg1 = StringUtil.replace(MusicClient.STRINGS.get("IDSTR_REG_MSG1"), "\\n", "\n");
    static final String iMsg2 = StringUtil.replace(MusicClient.STRINGS.get("IDSTR_REG_MSG2"), "\\n", "\n");
    static final String iSignup = MusicClient.STRINGS.get("IDSTR_REG_SIGNUP");
    static final String iRegKey = MusicClient.STRINGS.get("IDSTR_REG_KEY");
    static final String iCannotVerify = MusicClient.STRINGS.get("IDSTR_MSG_CANNOT_VERIFY");
    static final String iInvalidKey = MusicClient.STRINGS.get("IDSTR_MSG_INVALID_KEY");
    static final String iExpiredKey = MusicClient.STRINGS.get("IDSTR_MSG_EXPIRED_KEY");
    static final String iMsgCannotReachServer = MusicClient.STRINGS.get("IDSTR_MSG_CANNOT_REACH_SERVER");
    static final String iMailbox = MusicClient.STRINGS.get("IDSTR_MAILBOX");
    static final String iConnecting = MusicClient.STRINGS.get("IDSTR_CONNECTING");
    static final String iInvalidEmail = MusicClient.STRINGS.get("IDSTR_INVALID_EMAIL");
    static final String iEmail = MusicClient.STRINGS.get("IDSTR_EMAIL");
    static final String iEnterEmail = MusicClient.STRINGS.get("IDSTR_ENTER_EMAIL");
    JButton ok;
    JButton trial;
    JButton cancel;
    JTextField key;
    String orig;
    MusicClient client;
    boolean cleanExit = false;

    RegistrationDialog(MusicClient musicClient) {
        super(musicClient, MusicClient.STRINGS.get("IDSTR_J_REGISTRATION"), true);
        this.client = musicClient;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RegistrationDialog.this.client.enableMenus(true);
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(10, 0));
        jPanel.setOpaque(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setOpaque(false);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel3.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel3.setOpaque(false);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBackground(jPanel2.getBackground());
        jTextArea.setEditable(false);
        jTextArea.setFont(new JLabel().getFont());
        jTextArea.setText(iMsg2);
        jPanel2.add(jTextArea);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Label2 label2 = new Label2(iRegKey);
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        jPanel3.add(label2);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.orig = this.client.getKey();
        this.key = new JTextField();
        ClipboardUtil.addMenu(this.key);
        if (this.orig != null) {
            this.key.setText(this.orig);
        }
        this.key.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                RegistrationDialog.this.checkReady();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                RegistrationDialog.this.checkReady();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RegistrationDialog.this.checkReady();
            }
        });
        this.key.requestFocus();
        gridBagLayout.setConstraints(this.key, gridBagConstraints);
        jPanel3.add(this.key);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setOpaque(false);
        this.ok = new JButton(MusicClient.iOK);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(this){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        boolean bl = true;
                        String string = 3.access$000(this.this$1).key.getText().trim();
                        if (3.access$000(this.this$1).orig == null || !3.access$000(this.this$1).orig.equals(string)) {
                            3.access$000(this.this$1).ok.setEnabled(false);
                            long l = NativeEngine.checkKey(string);
                            if (string.length() == 0) {
                                string = null;
                            } else if (l == 0L) {
                                3.access$000(this.this$1).client.showMessage(iCannotVerify);
                            } else if (l == 1L) {
                                3.access$000(this.this$1).client.showMessage(iInvalidKey);
                                bl = false;
                            } else if (l == 2L) {
                                3.access$000(this.this$1).client.showMessage(iExpiredKey);
                            }
                        }
                        if (bl) {
                            if (3.access$000(this.this$1).apply()) {
                                3.access$000(this.this$1).cleanExit = true;
                                3.access$000(this.this$1).setVisible(false);
                                3.access$000(this.this$1).flushKey();
                                3.access$000(this.this$1).client.enableMenus(true);
                            }
                        } else {
                            3.access$000(this.this$1).ok.setEnabled(true);
                        }
                    }
                }.start();
            }

            static /* synthetic */ RegistrationDialog access$000(3 var0) {
                return var0.RegistrationDialog.this;
            }
        });
        this.getRootPane().setDefaultButton(this.ok);
        jPanel4.add(this.ok);
        this.trial = new JButton(iTrial);
        this.trial.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegistrationDialog.this.setVisible(false);
                String string = null;
                do {
                    if ((string = JOptionPane.showInputDialog(RegistrationDialog.this.client, iEnterEmail, iEmail, -1)) != null) continue;
                    return;
                } while (string.length() < 5 || string.indexOf("@") <= 0 || string.indexOf(".") <= 0);
                String string2 = string;
                new Thread(this, string2){
                    private final /* synthetic */ String val$_email;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$_email = string;
                    }

                    public void run() {
                        String string = NativeEngine.getTrialKey(this.val$_email, false);
                        SwingUtilities.invokeLater(new Runnable(this, string){
                            private final /* synthetic */ String val$newkey;
                            private final /* synthetic */ 6 this$2;
                            {
                                this.this$2 = var1_1;
                                this.val$newkey = string;
                            }

                            public void run() {
                                if (this.val$newkey == null) {
                                    5.access$200(6.access$100(this.this$2)).client.showMessage(iMsgCannotReachServer);
                                } else if (this.val$newkey.charAt(0) == '-') {
                                    5.access$200(6.access$100(this.this$2)).client.showMessage(this.val$newkey.substring(1));
                                } else {
                                    5.access$200(6.access$100(this.this$2)).client.showMessage(iMailbox);
                                }
                            }
                        });
                    }

                    static /* synthetic */ 5 access$100(6 var0) {
                        return var0.this$1;
                    }
                }.start();
            }

            static /* synthetic */ RegistrationDialog access$200(5 var0) {
                return var0.RegistrationDialog.this;
            }
        });
        jPanel4.add(this.trial);
        if (this.orig != null && this.orig.length() > 0) {
            this.trial.setEnabled(false);
        }
        this.cancel = new JButton(MusicClient.iCancel);
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegistrationDialog.this.setVisible(false);
                RegistrationDialog.this.client.enableMenus(true);
            }
        });
        jPanel4.add(this.cancel);
        jPanel.add("Center", jPanel2);
        jPanel.add("South", jPanel4);
        this.getContentPane().add(jPanel);
        jPanel.setBorder(new EmptyBorder(Skin.getSkin().infoInsets));
        this.pack();
        DialogUtil.centerDialog(this.client, this);
        this.setResizable(false);
        this.setVisible(true);
    }

    JPanel createLabel(final String string) {
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 3));
        jPanel.setOpaque(false);
        jPanel.add(new Label2(string){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = this.getFontMetrics(this.getFont()).stringWidth(string);
                return dimension;
            }
        });
        return jPanel;
    }

    boolean apply() {
        this.client.setKey(this.key.getText().trim());
        return true;
    }

    void checkReady() {
        boolean bl = false;
        String string = this.key.getText().trim();
        if (string.length() == 24 || string.length() == 0) {
            bl = true;
        }
        this.ok.setEnabled(bl);
        if (bl) {
            this.getRootPane().setDefaultButton(this.ok);
        }
    }

    void flushKey() {
        if (this.client.getKey() != null && !StringUtil.equals(this.orig, this.client.getKey())) {
            this.client.saveKey();
        }
    }
}

