/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import music.cpp.client.AboutDialog;
import music.cpp.client.DeviceThunk;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeEngine;
import music.cpp.client.Status;
import music.cpp.client.StringUtil;

public class PropertiesDialog
extends JDialog {
    static final String iLibraryName = MusicClient.STRINGS.get("IDSTR_LIBRARY_NAME");
    static final String iPDSongPattern = MusicClient.STRINGS.get("IDSTR_PD_SONG_PATTERN");
    static final String iPDPlaylistPattern = MusicClient.STRINGS.get("IDSTR_PD_PLAYLIST_PATTERN");
    static final String iPDTotalSpace = MusicClient.STRINGS.get("IDSTR_PD_TOTAL_SPACE");
    static final String iPDFreeSpace = MusicClient.STRINGS.get("IDSTR_PD_FREE_SPACE");
    String songPublishPattern = null;
    String playlistPublishPattern = null;
    JTextField spp;
    JTextField ppp;
    boolean showPatterns = false;
    DeviceThunk thunk = null;

    public PropertiesDialog(MusicClient musicClient, DeviceThunk deviceThunk) {
        super(musicClient, (deviceThunk == null ? iLibraryName : deviceThunk.getName()) + " " + MusicClient.iProperties, true);
        JLabel jLabel;
        this.thunk = deviceThunk;
        Status status = musicClient.getStatus(this.thunk);
        if (this.thunk == null) {
            this.thunk = NativeEngine.getDiskThunk(musicClient.getUserEngineID());
        }
        this.showPatterns = false;
        if (this.thunk != null && this.thunk.getDeviceManagerID() == 1) {
            this.songPublishPattern = this.thunk.getSongPublishPattern();
            this.playlistPublishPattern = this.thunk.getPlaylistPublishPattern();
            this.showPatterns = true;
        }
        JPanel jPanel = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = Math.max(dimension.height, 200);
                dimension.width = Math.max(dimension.width, 500);
                return dimension;
            }
        };
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel2.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        if (this.showPatterns) {
            jLabel = new JLabel(iPDSongPattern);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            this.spp = new JTextField(this.songPublishPattern);
            gridBagLayout.setConstraints(this.spp, gridBagConstraints);
            jPanel2.add(this.spp);
            gridBagConstraints.insets.bottom += 20;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            jLabel = new JLabel(iPDPlaylistPattern);
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            this.ppp = new JTextField(this.playlistPublishPattern);
            gridBagLayout.setConstraints(this.ppp, gridBagConstraints);
            jPanel2.add(this.ppp);
            gridBagConstraints.insets.bottom -= 20;
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
        }
        if (status != null) {
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 0;
            jLabel = new JLabel(AboutDialog.iAbout5 + StringUtil.l2ac(status.getTotal()));
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            ++gridBagConstraints.gridy;
            int n = status.getVerify();
            jLabel = new JLabel(AboutDialog.iAbout6 + StringUtil.l2ac(status.getHasData()) + (n == 0 ? "" : (n == 1 ? AboutDialog.iNeedsVerification : MusicClient.STRINGS.expand("IDSTR_NEED_VERIFICATION", new String[]{StringUtil.l2ac(n)}))));
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
            ++gridBagConstraints.gridy;
            jLabel = new JLabel(AboutDialog.iAbout7 + StringUtil.l2ac(status.getDead()));
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel2.add(jLabel);
        }
        jPanel.add("Center", jPanel2);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(MusicClient.iOK);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (PropertiesDialog.this.showPatterns && PropertiesDialog.this.thunk != null) {
                    PropertiesDialog.this.thunk.setSongPublishPattern(PropertiesDialog.this.spp.getText());
                    PropertiesDialog.this.thunk.setPlaylistPublishPattern(PropertiesDialog.this.ppp.getText());
                }
                PropertiesDialog.this.setVisible(false);
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(MusicClient.iCancel);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.setVisible(false);
            }
        });
        jPanel3.add(jButton2);
        jPanel.add("South", jPanel3);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(musicClient);
        this.setResizable(false);
        this.setVisible(true);
    }
}

