/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import music.cpp.client.App;
import music.cpp.client.CheckBox2;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;

public class PlaylistOptions
extends JPanel {
    static final String iMixSize = MusicClient.STRINGS.get("IDSTR_MIX_SIZE");
    static final String iTracks = MusicClient.STRINGS.get("IDSTR_MIX_TRACKS");
    static final String iMinutes = MusicClient.STRINGS.get("IDSTR_MIX_MINUTES");
    static final String iMegabytes = MusicClient.STRINGS.get("IDSTR_MIX_MB");
    static final String iStyle = MusicClient.STRINGS.get("IDSTR_MIX_STYLE");
    static final String iIgnore = MusicClient.STRINGS.get("IDSTR_MIX_IGNORE");
    static final String iPrefer = MusicClient.STRINGS.get("IDSTR_MIX_PREFER");
    static final String iVariety = MusicClient.STRINGS.get("IDSTR_MIX_VARIETY");
    static final String iLow = MusicClient.STRINGS.get("IDSTR_MIX_LOW");
    static final String iHigh = MusicClient.STRINGS.get("IDSTR_MIX_HIGH");
    static final String iRestrict = MusicClient.STRINGS.get("IDSTR_MIX_RESTRICT");
    static final String iReject = MusicClient.STRINGS.get("IDSTR_MIX_REJECT");
    static final String iRejectSize = MusicClient.STRINGS.get("IDSTR_MIX_REJECT_SIZE");
    static final String iSetDefaults = MusicClient.STRINGS.get("IDSTR_SETDEFAULTS");
    static final String iBuyAnySizeMix = MusicClient.STRINGS.get("IDSTR_BUY_2");
    JButton reset;
    JComboBox filterList;
    JComboBox dupList;
    JTextField playlistSize;
    JTextField restrictArtistDuplicatesField;
    CheckBox2 restrict;
    CheckBox2 reject;
    JSlider genrePreference;
    JSlider variety;
    MusicClient client;

    public PlaylistOptions(MusicClient musicClient) {
        super(new BorderLayout());
        this.client = musicClient;
        this.setOpaque(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        GridBagLayout gridBagLayout = (GridBagLayout)jPanel.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        String[] stringArray = new String[]{iTracks, iMinutes, iMegabytes};
        this.filterList = new JComboBox<String>(stringArray);
        if (this.client.getPlaylistType() == 0) {
            this.filterList.setSelectedIndex(0);
        } else if (this.client.getPlaylistType() == 1) {
            this.filterList.setSelectedIndex(1);
        } else {
            this.filterList.setSelectedIndex(2);
        }
        JLabel jLabel = new JLabel(iMixSize);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        this.playlistSize = new JTextField(10);
        this.playlistSize.setText(String.valueOf(this.client.getPlaylistSize()));
        this.playlistSize.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PlaylistOptions.this.checkReady();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PlaylistOptions.this.checkReady();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PlaylistOptions.this.checkReady();
            }
        });
        gridBagLayout.setConstraints(this.playlistSize, gridBagConstraints);
        jPanel.add(this.playlistSize);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.filterList, gridBagConstraints);
        jPanel.add(this.filterList);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.fill = 0;
        jLabel = new Label2(iStyle);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        jLabel = new Label2(iIgnore);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.genrePreference = new JSlider(0, 200, this.client.getGenrePreference());
        this.genrePreference.setOpaque(false);
        this.genrePreference.setMajorTickSpacing(20);
        gridBagLayout.setConstraints(this.genrePreference, gridBagConstraints);
        jPanel.add(this.genrePreference);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jLabel = new Label2(iPrefer);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 20;
        jLabel = new Label2(iVariety);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        jLabel = new Label2(iLow);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        this.variety = new JSlider(0, 9, this.client.getVariety());
        this.variety.setOpaque(false);
        this.variety.setMajorTickSpacing(1);
        gridBagLayout.setConstraints(this.variety, gridBagConstraints);
        jPanel.add(this.variety);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jLabel = new Label2(iHigh);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.restrict = new CheckBox2(iRestrict, this.client.getRestrictToGenre());
        gridBagLayout.setConstraints(this.restrict, gridBagConstraints);
        jPanel.add(this.restrict);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        this.reject = new CheckBox2(iReject, this.client.getRestrictArtistCount());
        gridBagLayout.setConstraints(this.reject, gridBagConstraints);
        jPanel.add(this.reject);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 7;
        jLabel = new Label2(iRejectSize);
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        this.restrictArtistDuplicatesField = new JTextField(10);
        gridBagLayout.setConstraints(this.restrictArtistDuplicatesField, gridBagConstraints);
        this.restrictArtistDuplicatesField.setText(String.valueOf(this.client.getRestrictDuplicateArtistCount()));
        jPanel.add(this.restrictArtistDuplicatesField);
        this.dupList = new JComboBox<String>(stringArray);
        if (this.client.getDupArtistType() == 0) {
            this.dupList.setSelectedIndex(0);
        } else if (this.client.getDupArtistType() == 1) {
            this.dupList.setSelectedIndex(1);
        } else {
            this.dupList.setSelectedIndex(2);
        }
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.dupList, gridBagConstraints);
        jPanel.add(this.dupList);
        this.add("Center", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        this.reset = new JButton(iSetDefaults);
        this.reset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlaylistOptions.this.reset();
            }
        });
        jPanel2.add(this.reset);
        this.add("South", jPanel2);
    }

    void reset() {
        this.genrePreference.setValue(10);
        this.variety.setValue(0);
        this.filterList.setSelectedIndex(0);
        this.dupList.setSelectedIndex(0);
        this.restrictArtistDuplicatesField.setText("3");
        this.playlistSize.setText("12");
    }

    boolean apply() {
        int n = this.filterList.getSelectedIndex();
        if (n == 0) {
            this.client.setPlaylistType(0);
        } else if (n == 1) {
            this.client.setPlaylistType(1);
        } else {
            this.client.setPlaylistType(2);
        }
        n = this.dupList.getSelectedIndex();
        if (n == 0) {
            this.client.setDupArtistType(0);
        } else if (n == 1) {
            this.client.setDupArtistType(1);
        } else {
            this.client.setDupArtistType(2);
        }
        try {
            int n2 = Integer.parseInt(this.playlistSize.getText());
            if (!this.client.active) {
                switch (n) {
                    case 0: {
                        if (n2 <= 75) break;
                        this.client.showMessage(iBuyAnySizeMix, true);
                        n2 = 75;
                        this.playlistSize.setText("75");
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (n2 <= 300) break;
                        this.client.showMessage(iBuyAnySizeMix, true);
                        n2 = 300;
                        this.playlistSize.setText("300");
                    }
                }
            }
            this.client.setPlaylistSize(n2);
            int n3 = Integer.parseInt(this.restrictArtistDuplicatesField.getText());
            this.client.setRestrictDuplicateArtistCount(n3);
        }
        catch (NumberFormatException numberFormatException) {
            App.logException(numberFormatException);
        }
        this.client.setGenrePreference(this.genrePreference.getValue());
        this.client.setVariety(this.variety.getValue());
        this.client.setRestrictArtistCount(this.reject.isSelected());
        this.client.setRestrictToGenre(this.restrict.isSelected());
        return true;
    }

    void checkReady() {
        boolean bl = false;
        try {
            int n = Integer.parseInt(this.playlistSize.getText());
            if (n > 0) {
                bl = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
    }
}

