/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import music.cpp.client.Skin;

public class PlatinumButton
extends JButton {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int OVER = 2;
    public static final int INACT = 3;
    int state = 0;
    Icon up;
    Icon down;
    Icon over;
    Icon inact;
    boolean isTab = false;
    boolean activeTab = false;
    static Skin skin = Skin.getSkin();
    public static final PlatinumButton PLAY = new PlatinumButton(PlatinumButton.skin.btn_play, PlatinumButton.skin.btn_play_down, PlatinumButton.skin.btn_play_over, PlatinumButton.skin.btn_play_inact);
    public static final PlatinumButton PLAYLIST = new PlatinumButton(PlatinumButton.skin.btn_playlist, PlatinumButton.skin.btn_playlist_down, PlatinumButton.skin.btn_playlist_over, PlatinumButton.skin.btn_playlist_inact);
    public static final PlatinumButton SHUFFLE = new PlatinumButton(PlatinumButton.skin.btn_shuffle, PlatinumButton.skin.btn_shuffle_down, PlatinumButton.skin.btn_shuffle_over, PlatinumButton.skin.btn_shuffle_inact);
    public static final PlatinumButton DEVICE = new PlatinumButton(PlatinumButton.skin.btn_device, PlatinumButton.skin.btn_device_down, PlatinumButton.skin.btn_device_over, PlatinumButton.skin.btn_device_inact);
    public static final PlatinumButton STORE = new PlatinumButton(PlatinumButton.skin.btn_store, PlatinumButton.skin.btn_store_down, PlatinumButton.skin.btn_store_over, PlatinumButton.skin.btn_store_inact);
    public static final PlatinumButton PREV = new PlatinumButton(PlatinumButton.skin.btn_hist_prev, PlatinumButton.skin.btn_hist_prev_down, PlatinumButton.skin.btn_hist_prev_over, PlatinumButton.skin.btn_hist_prev_inact);
    public static final PlatinumButton NEXT = new PlatinumButton(PlatinumButton.skin.btn_hist_next, PlatinumButton.skin.btn_hist_next_down, PlatinumButton.skin.btn_hist_next_over, PlatinumButton.skin.btn_hist_next_inact);

    public static PlatinumButton button(String string) {
        return new PlatinumButton(string, PlatinumButton.skin.button, PlatinumButton.skin.button2, PlatinumButton.skin.button, PlatinumButton.skin.button);
    }

    public static PlatinumButton longButton(String string) {
        return new PlatinumButton(string, PlatinumButton.skin.longbutton, PlatinumButton.skin.longbutton2, PlatinumButton.skin.longbutton, PlatinumButton.skin.longbutton);
    }

    public PlatinumButton(String string) {
        this(string, null, null, null, null);
    }

    public PlatinumButton(Icon icon, Icon icon2, Icon icon3, Icon icon4) {
        this(null, icon, icon2, icon3, icon4);
    }

    public PlatinumButton(String string, Icon icon, Icon icon2, Icon icon3, Icon icon4) {
        super(string == null ? "" : string);
        this.up = icon;
        this.down = icon2;
        this.over = icon3;
        this.inact = icon4;
        this.setOpaque(false);
        this.setBorder(null);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PlatinumButton.this.state = PlatinumButton.this.isEnabled() ? 1 : 3;
                PlatinumButton.this.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PlatinumButton.this.state = PlatinumButton.this.isEnabled() ? 0 : 3;
                PlatinumButton.this.repaint();
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                PlatinumButton.this.state = PlatinumButton.this.isEnabled() ? 2 : 3;
                PlatinumButton.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                PlatinumButton.this.state = PlatinumButton.this.isEnabled() ? 0 : 3;
                PlatinumButton.this.repaint();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                PlatinumButton.this.state = PlatinumButton.this.isEnabled() ? 0 : 3;
                PlatinumButton.this.repaint();
            }
        });
    }

    public void paint(Graphics graphics) {
        int n;
        int n2 = this.getHeight();
        int n3 = this.getWidth();
        int n4 = n = this.isTab && !this.activeTab ? 2 : 0;
        if (this.up != null && this.down != null && this.over != null && this.inact != null) {
            switch (this.state) {
                case 0: {
                    this.up.paintIcon(this, graphics, 0, n);
                    break;
                }
                case 1: {
                    this.down.paintIcon(this, graphics, 0, n);
                    break;
                }
                case 2: {
                    this.over.paintIcon(this, graphics, 0, n);
                    break;
                }
                case 3: {
                    this.inact.paintIcon(this, graphics, 0, n);
                }
            }
        } else {
            graphics.setColor(PlatinumButton.skin.bgColor);
            graphics.fillRect(0, 0, n3, n2);
            if (this.state == 1) {
                graphics.setColor(PlatinumButton.skin.dkShadowColor);
                graphics.drawLine(0, 0, n3, 0);
                graphics.drawLine(0, 0, 0, n2);
                graphics.setColor(PlatinumButton.skin.ltHighlightColor);
                graphics.drawLine(0, n2 - 1, n3, n2 - 1);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n2);
            } else if (this.state == 2) {
                graphics.setColor(PlatinumButton.skin.dkHighlightColor);
                graphics.drawLine(0, 0, n3, 0);
                graphics.drawLine(0, 0, 0, n2);
                graphics.setColor(PlatinumButton.skin.dkShadowColor);
                graphics.drawLine(0, n2 - 1, n3, n2 - 1);
                graphics.drawLine(n3 - 1, 0, n3 - 1, n2);
            }
        }
        String string = this.getText();
        if (this.isTab) {
            graphics.setColor(PlatinumButton.skin.textColor);
        } else {
            if (this.state == 2) {
                graphics.setColor(PlatinumButton.skin.buttonTextColor2);
            } else if (this.state == 3) {
                graphics.setColor(PlatinumButton.skin.disabledColor);
            } else {
                graphics.setColor(PlatinumButton.skin.buttonTextColor);
            }
            graphics.setFont(PlatinumButton.skin.smallFont);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = fontMetrics.stringWidth(string);
        int n6 = this.isTab ? 0 : 1;
        int n7 = (n2 + fontMetrics.getAscent()) / 2 + (this.state == 1 ? -2 + n6 : -2);
        int n8 = (n3 - n5) / 2 + (this.state == 1 ? n6 : 0);
        graphics.drawString(string, n8, n7 + n);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.up == null) {
            return new Dimension(PlatinumButton.skin.buttonWidth, PlatinumButton.skin.buttonHeight);
        }
        return new Dimension(this.up.getIconWidth(), this.up.getIconHeight());
    }

    protected void paintComponent(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        super.paintComponent(graphics);
    }

    public void paintBorder(Graphics graphics) {
    }

    public void setEnabled(boolean bl) {
        if (!this.isEnabled() && bl) {
            this.state = 0;
        } else if (!bl) {
            this.state = 3;
        }
        super.setEnabled(bl);
    }
}

