/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import music.cpp.client.Album;
import music.cpp.client.App;
import music.cpp.client.Artist;
import music.cpp.client.DeviceThunk;
import music.cpp.client.Engine;
import music.cpp.client.GenreInfo;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeCodeException;
import music.cpp.client.NativeDLL;
import music.cpp.client.NativeSong;
import music.cpp.client.Song;
import music.cpp.client.SongFilter;
import music.cpp.client.Status;
import music.cpp.client.TagWriter;
import music.cpp.client.UserPlaylist;

public class NativeEngine
implements Engine {
    private long engine;
    public static NativeDLL dll = new NativeDLL("NativeEngine");

    public NativeEngine(MusicClient musicClient, File file, boolean bl, boolean bl2) throws NativeCodeException {
        if (!dll.isLoaded()) {
            throw new NativeCodeException("NativeEngine");
        }
        this.engine = NativeEngine.initEngine(musicClient, file.getAbsolutePath(), bl, bl2);
    }

    public NativeEngine(long l) {
        this.engine = l;
    }

    public boolean checkSong(Song song) {
        return this.checkSong(this.engine, song);
    }

    public boolean checkAlbum(Album album) {
        return this.checkAlbum(this.engine, album);
    }

    public boolean checkArtist(Artist artist) {
        return this.checkArtist(this.engine, artist);
    }

    public Vector getGenres() {
        return this.getGenres(this.engine);
    }

    public Vector getArtists(GenreInfo[] genreInfoArray, boolean bl) {
        return this.getArtists(this.engine, genreInfoArray, bl);
    }

    public Vector getAlbums(Artist[] artistArray, boolean bl) {
        return this.getAlbums(this.engine, artistArray, bl);
    }

    public Vector nearestArtists(Artist artist) {
        return this.nearestArtists(this.engine, artist);
    }

    public Vector nearestAlbums(Album album) {
        return this.nearestAlbums(this.engine, album);
    }

    public void setGenres(GenreInfo[] genreInfoArray) {
        this.setGenres(this.engine, genreInfoArray);
    }

    public Song getSongByFile(String string) {
        return this.getSong(this.engine, string);
    }

    public Vector getSongs() {
        return this.getSongs(this.engine);
    }

    public Vector getSongs(String string, boolean bl) {
        return this.getSongs(this.engine, string, bl);
    }

    public Vector getSongs(Album album, boolean bl) {
        return this.getSongs(this.engine, album, bl);
    }

    public Vector getSongs(Artist artist, boolean bl) {
        return this.getSongs(this.engine, artist, bl);
    }

    public Vector getArtists(Song song) {
        return new Vector();
    }

    public Vector playlist(Song[] songArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.getPlaylist(this.engine, songArray, n, n2, n3, n4, n5, n6);
    }

    public Vector remix(Song[] songArray, Vector vector, Vector vector2, Vector vector3, Vector vector4, int n, int n2, int n3, int n4, int n5, int n6) {
        return this.getRemix(this.engine, songArray, vector, vector2, vector3, vector4, n, n2, n3, n4, n5, n6);
    }

    public Vector getDuplicates() {
        return this.getDuplicates(this.engine);
    }

    public Vector getUnanalyzable() {
        return this.getUnanalyzable(this.engine);
    }

    public void shuffle(Vector vector, int n) {
        this.shuffle(this.engine, vector, n);
    }

    public boolean delete(Song song, boolean bl) {
        return this.delete(this.engine, ((NativeSong)song).getID(), bl);
    }

    public Vector addMusic(String string, boolean bl) {
        return this.addMusic(this.engine, string, bl);
    }

    public boolean refresh(Song song, boolean bl, boolean bl2) {
        if (song == null) {
            return this.refresh(this.engine, 0L, bl, bl2);
        }
        return this.refresh(this.engine, ((NativeSong)song).getID(), bl, bl2);
    }

    public void process(Song[] songArray) {
        this.process(this.engine, songArray);
    }

    public Status getStatus() {
        return this.getStatus(Status.class, this.engine);
    }

    public int size() {
        return this.size(this.engine);
    }

    public void shutdown() {
        this.shutdown(this.engine);
    }

    public void startMonitor() {
        this.startMonitor(this.engine);
    }

    public void stuffArchive() {
        this.stuffArchive(this.engine);
    }

    public void calibrate() {
        this.calibrate(this.engine);
    }

    public void flush(boolean bl) {
        this.flush(bl, this.engine);
    }

    public void stopProcessing() {
        this.stopProcessing(this.engine);
    }

    public boolean areWorkersRunning() {
        return this.areWorkersRunning(this.engine);
    }

    public String getWorkerStatus() {
        return this.getWorkerStatus(this.engine);
    }

    public void setDirty(boolean bl) {
        this.setDirty(this.engine, bl);
    }

    public Vector getFilters() {
        Vector vector = this.getFilters(this.engine);
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public SongFilter getFilter() {
        return this.getFilter(this.engine);
    }

    public void setFilter(SongFilter songFilter) {
        this.setFilter(this.engine, songFilter == null ? 0L : songFilter.getID());
    }

    public void deleteFilter(SongFilter songFilter) {
        this.deleteFilter(this.engine, songFilter.getID());
    }

    public SongFilter addFilter(String string, int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, boolean bl) {
        return this.addFilter(this.engine, string, n, nArray, nArray2, stringArray, stringArray2, bl);
    }

    public void updateFilter(SongFilter songFilter, String string, int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, boolean bl) {
        this.updateFilter(this.engine, songFilter.getID(), string, n, nArray, nArray2, stringArray, stringArray2, bl);
    }

    public SongFilter customFilter(int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, boolean bl) {
        return this.customFilter(this.engine, n, nArray, nArray2, stringArray, stringArray2, bl);
    }

    public Vector getPlaylists() {
        Vector vector = this.getPlaylists(this.engine);
        if (vector == null) {
            vector = new Vector();
        }
        return vector;
    }

    public UserPlaylist addPlaylist(String string) {
        return this.addPlaylist(this.engine, string);
    }

    public UserPlaylist addDevicePlaylist(String string, DeviceThunk deviceThunk) {
        return this.addDevicePlaylist(this.engine, string, deviceThunk.getID());
    }

    public void deletePlaylist(UserPlaylist userPlaylist) {
        this.deletePlaylist(this.engine, userPlaylist.getID());
    }

    public String savePlaylist(UserPlaylist userPlaylist) {
        return this.savePlaylist(this.engine, userPlaylist.getID());
    }

    public boolean storeData(Song song) {
        return this.storeData(this.engine, song.getID());
    }

    public Vector morphPlaylist(Vector vector, int n, boolean bl, int n2, int n3) {
        return this.morphPlaylist(this.engine, vector, n, bl, n2, n3);
    }

    public void setShowInArtistList(int n) {
        this.setShowInArtistList(this.engine, n);
    }

    public int getShowInArtistList() {
        return this.getShowInArtistList(this.engine);
    }

    public void startMMServer(int n) {
        this.startMMServer(this.engine, n);
    }

    public void stopMMServer() {
        this.stopMMServer(this.engine);
    }

    public boolean isMMServerRunning() {
        return this.isMMServerRunning(this.engine);
    }

    public Vector getServers() {
        return this.getServers(this.engine);
    }

    public void enableTiVo(boolean bl) {
        this.enableTiVo(this.engine, bl);
    }

    public void enableAPI(boolean bl) {
        this.enableAPI(this.engine, bl);
    }

    public boolean isTiVoEnabled() {
        return this.isTiVoEnabled(this.engine);
    }

    public boolean isAPIEnabled() {
        return this.isAPIEnabled(this.engine);
    }

    public Vector getAutoFixSuggestionsByPattern(Song song, String string, String string2, boolean bl, boolean bl2) {
        return this.getAutoFixSuggestionsByPattern(this.engine, song.getID(), string, string2, bl, bl2);
    }

    public Vector getAutoFixSuggestionsByFile(Song song, String string, boolean bl, boolean bl2) {
        return this.getAutoFixSuggestionsByFile(this.engine, song.getID(), string, bl, bl2);
    }

    public Vector applyEdits(Vector vector, Vector vector2) {
        return this.applyEdits(this.engine, vector, vector2);
    }

    public Vector organizeFiles(Vector vector, boolean bl, boolean bl2, Vector vector2) {
        return this.organizeFiles(this.engine, vector, bl, bl2, vector2);
    }

    public boolean tagsDiffer(Song song, int n, String string, String string2) {
        return this.tagsDiffer(this.engine, song.getID(), n, string, string2);
    }

    public String getFile() {
        return this.getFile(this.engine);
    }

    public void setFile(String string) {
        this.setFile(this.engine, string);
    }

    public DeviceThunk getOwnedThunk() {
        return this.getOwnedThunk(this.engine);
    }

    public void setOwnedThunk(DeviceThunk deviceThunk) {
        this.setOwnedThunk(this.engine, deviceThunk.getID());
    }

    public void dump() {
        this.dump(this.engine);
    }

    public static void setExclusion(int n, SongFilter songFilter) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            songFilter.writeExternal(dataOutputStream);
            dataOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            NativeEngine.setExclusion(n, byArray, byArray.length);
        }
        catch (IOException iOException) {
            App.logException(iOException);
        }
    }

    long getID() {
        return this.engine;
    }

    public String fillInPattern(String string, long l, boolean bl) {
        return NativeEngine.fillInPattern(string, this.engine, l, bl);
    }

    private static native long initEngine(MusicClient var0, String var1, boolean var2, boolean var3);

    public static native void disconnect();

    public static native String getProxy();

    public static native void setProxy(String var0, int var1);

    public static native void setProxyAuth(String var0, String var1);

    public static native void lock();

    public static native void unlock();

    public static native void setHost(String var0);

    public static native void setOption(String var0, String var1);

    public static native long checkKey(String var0);

    public static native TagWriter getTagWriter(String var0, boolean var1);

    public static native void deleteTagWriter(long var0, int var2);

    public static native String[] checkForUpdates();

    public static native void setAddPlaylistsOnScan(boolean var0);

    public static native boolean getScanVBR();

    public static native void setScanVBR(boolean var0);

    public static native boolean getID3V24();

    public static native void setID3V24(boolean var0);

    public static native Vector getThunks();

    public static native long getReactivity();

    public static native void setReactivity(long var0);

    public static native void enableDiskDevices();

    public static native void enablePhilips();

    public static native void loadThunks();

    public static native void scanThunks();

    public static native void closeThunks();

    public static native boolean validateFile(String var0);

    public static native String fillInPattern(String var0, long var1, long var3, boolean var5);

    public static native int validatePattern(String var0, long var1);

    public static native DeviceThunk getDiskThunk(long var0);

    public static native String getTrialKey(String var0, boolean var1);

    public static native DeviceThunk createDiskThunk(String var0, String var1, boolean var2);

    public static native Vector detectSlimServers();

    public static native void playOnSlimServer(Vector var0, int var1);

    public static native int getMaxPath();

    private static native void setExclusion(int var0, byte[] var1, int var2);

    private native void dump(long var1);

    private native boolean checkSong(long var1, Song var3);

    private native boolean checkArtist(long var1, Artist var3);

    private native boolean checkAlbum(long var1, Album var3);

    private native void setGenres(long var1, GenreInfo[] var3);

    private native Vector getGenres(long var1);

    private native Vector getArtists(long var1, GenreInfo[] var3, boolean var4);

    private native Vector getAlbums(long var1, Artist[] var3, boolean var4);

    private native Vector nearestArtists(long var1, Artist var3);

    private native Vector nearestAlbums(long var1, Album var3);

    private native Song getSong(long var1, String var3);

    private native Vector getSongs(long var1);

    private native Vector getSongs(long var1, Artist var3, boolean var4);

    private native Vector getSongs(long var1, Album var3, boolean var4);

    private native Vector getSongs(long var1, String var3, boolean var4);

    private native Vector getPlaylist(long var1, Song[] var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native Vector getRemix(long var1, Song[] var3, Vector var4, Vector var5, Vector var6, Vector var7, int var8, int var9, int var10, int var11, int var12, int var13);

    private native Vector getDuplicates(long var1);

    private native Vector getUnanalyzable(long var1);

    private native void shuffle(long var1, Vector var3, int var4);

    private native boolean delete(long var1, long var3, boolean var5);

    private native Vector addMusic(long var1, String var3, boolean var4);

    private native boolean refresh(long var1, long var3, boolean var5, boolean var6);

    private native void process(long var1, Song[] var3);

    private native Status getStatus(Class var1, long var2);

    private native int size(long var1);

    private native void shutdown(long var1);

    private native void startMonitor(long var1);

    private native void stuffArchive(long var1);

    private native void calibrate(long var1);

    private native void flush(boolean var1, long var2);

    private native boolean areWorkersRunning(long var1);

    private native String getWorkerStatus(long var1);

    private native void stopProcessing(long var1);

    private native void setDirty(long var1, boolean var3);

    private native Vector getFilters(long var1);

    private native SongFilter getFilter(long var1);

    private native void setFilter(long var1, long var3);

    private native void deleteFilter(long var1, long var3);

    private native SongFilter addFilter(long var1, String var3, int var4, int[] var5, int[] var6, String[] var7, String[] var8, boolean var9);

    private native void updateFilter(long var1, long var3, String var5, int var6, int[] var7, int[] var8, String[] var9, String[] var10, boolean var11);

    private native SongFilter customFilter(long var1, int var3, int[] var4, int[] var5, String[] var6, String[] var7, boolean var8);

    private native Vector getPlaylists(long var1);

    private native UserPlaylist addPlaylist(long var1, String var3);

    private native UserPlaylist addDevicePlaylist(long var1, String var3, long var4);

    private native void deletePlaylist(long var1, long var3);

    private native String savePlaylist(long var1, long var3);

    private native boolean storeData(long var1, long var3);

    private native Vector morphPlaylist(long var1, Vector var3, int var4, boolean var5, int var6, int var7);

    private native void setShowInArtistList(long var1, int var3);

    private native int getShowInArtistList(long var1);

    private native void startMMServer(long var1, int var3);

    private native void stopMMServer(long var1);

    private native boolean isMMServerRunning(long var1);

    private native Vector getServers(long var1);

    private native void enableTiVo(long var1, boolean var3);

    private native void enableAPI(long var1, boolean var3);

    private native boolean isTiVoEnabled(long var1);

    private native boolean isAPIEnabled(long var1);

    private native Vector getAutoFixSuggestionsByPattern(long var1, long var3, String var5, String var6, boolean var7, boolean var8);

    private native Vector getAutoFixSuggestionsByFile(long var1, long var3, String var5, boolean var6, boolean var7);

    private native Vector applyEdits(long var1, Vector var3, Vector var4);

    private native Vector organizeFiles(long var1, Vector var3, boolean var4, boolean var5, Vector var6);

    private native boolean tagsDiffer(long var1, long var3, int var5, String var6, String var7);

    private native String getFile(long var1);

    private native void setFile(long var1, String var3);

    private native DeviceThunk getOwnedThunk(long var1);

    private native void setOwnedThunk(long var1, long var3);
}

