/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.util.Iterator;
import java.util.Vector;
import music.cpp.client.Album;
import music.cpp.client.Artist;
import music.cpp.client.GenreInfo;
import music.cpp.client.MusicClient;
import music.cpp.client.NativeGenreInfo;
import music.cpp.client.Profile;
import music.cpp.client.Song;
import music.cpp.client.Util;

public class NativeAlbum
implements Album {
    private String name;
    private long id;

    public NativeAlbum(String string, long l) {
        this.name = string;
        this.id = l;
    }

    public boolean hasProfile() {
        return NativeAlbum.hasProfile(this.id);
    }

    public String name() {
        return this.name;
    }

    public int getYear() {
        return NativeAlbum.getYear(this.id);
    }

    public String toString() {
        return this.name;
    }

    public long getID() {
        return this.id;
    }

    public Artist artist() {
        return NativeAlbum.getArtist(this.id);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NativeAlbum)) {
            return false;
        }
        NativeAlbum nativeAlbum = (NativeAlbum)object;
        return this.id == nativeAlbum.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void reset() {
        this.id = 0L;
    }

    public boolean contains(GenreInfo genreInfo) {
        return NativeAlbum.contains(this.id, ((NativeGenreInfo)genreInfo).getID());
    }

    public boolean containsMultipleGenres() {
        return NativeAlbum.containsMultipleGenres(this.id);
    }

    public boolean containsMultipleArtists() {
        return NativeAlbum.containsMultipleArtists(this.id);
    }

    public boolean isFiltered(MusicClient musicClient) {
        Vector vector = musicClient.getSongs(this, false);
        if (vector != null) {
            boolean bl = musicClient.artistList.isSelectedIndex(0);
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                Song song = (Song)iterator.next();
                if (!musicClient.checkSong(song)) {
                    return true;
                }
                Artist artist = song.artist();
                int n = Util.indexOf(musicClient.artists, (Object)artist);
                if (n >= 0) {
                    if (bl || musicClient.artistList.isSelectedIndex(n)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    public void setName(String string) {
        this.name = string;
        this.setName(this.id, string);
    }

    private native void setName(long var1, String var3);

    public Profile getProfile() {
        return this.getProfile(this.id);
    }

    private static native Artist getArtist(long var0);

    private static native boolean hasProfile(long var0);

    private static native int getYear(long var0);

    private static native boolean contains(long var0, long var2);

    private static native boolean containsMultipleGenres(long var0);

    private static native boolean containsMultipleArtists(long var0);

    private native Profile getProfile(long var1);
}

