/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.filechooser.FileFilter;
import music.cpp.client.EnumerationIterator;

public class ExtensionFileFilter
extends FileFilter {
    private Hashtable filters = null;
    private String description = null;
    private String fullDescription = null;
    private boolean useExtensionsInDescription = true;

    public ExtensionFileFilter(String string) {
        this(string, null);
    }

    public ExtensionFileFilter(String string, String string2) {
        this(new String[]{string}, string2);
    }

    public ExtensionFileFilter(String[] stringArray) {
        this(stringArray, null);
    }

    public ExtensionFileFilter(String[] stringArray, String string) {
        this.filters = new Hashtable(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addExtension(stringArray[i]);
        }
        this.setDescription(string);
    }

    public ExtensionFileFilter(Vector vector, String string) {
        this.filters = new Hashtable(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            this.addExtension((String)vector.elementAt(i));
        }
        this.setDescription(string);
    }

    public boolean accept(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null && this.filters.get(this.getExtension(file)) != null) {
                return true;
            }
        }
        return false;
    }

    public String getExtension(File file) {
        String string;
        int n;
        if (file != null && (n = (string = file.getName()).lastIndexOf(46)) > 0 && n < string.length() - 1) {
            return string.substring(n + 1).toLowerCase();
        }
        return null;
    }

    public void addExtension(String string) {
        if (this.filters == null) {
            this.filters = new Hashtable(5);
        }
        this.filters.put(string.toLowerCase(), this);
        this.fullDescription = null;
    }

    public String getDescription() {
        if (this.fullDescription == null) {
            if (this.description == null || this.isExtensionListInDescription()) {
                if (this.description != null) {
                    this.fullDescription = this.description;
                }
                this.fullDescription = this.fullDescription + " (";
                Enumeration enumeration = this.filters.keys();
                if (enumeration != null) {
                    this.fullDescription = this.fullDescription + "*." + (String)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        this.fullDescription = this.fullDescription + ", *." + (String)enumeration.nextElement();
                    }
                }
                this.fullDescription = this.fullDescription + ")";
            } else {
                this.fullDescription = this.description;
            }
        }
        return this.fullDescription;
    }

    public void setDescription(String string) {
        this.description = string;
        this.fullDescription = null;
    }

    public void setExtensionListInDescription(boolean bl) {
        this.useExtensionsInDescription = bl;
        this.fullDescription = null;
    }

    public boolean isExtensionListInDescription() {
        return this.useExtensionsInDescription;
    }

    public Iterator getExtensions() {
        return new EnumerationIterator(this.filters.keys());
    }

    public String toString() {
        return this.description;
    }
}

