/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import music.cpp.client.ApplicationsPanel;
import music.cpp.client.ExclusionsPanel;
import music.cpp.client.GeneralOptions;
import music.cpp.client.LibraryOptions;
import music.cpp.client.MusicClient;
import music.cpp.client.PlaylistOptions;
import music.cpp.client.ServicesPanel;
import music.cpp.client.ShufflePanel;
import music.cpp.client.TableConfigurationPanel;

public class ConfigDialog
extends JDialog {
    static final String iApplications = MusicClient.STRINGS.get("IDSTR_J_APPLICATIONS");
    static final String iExclusions = MusicClient.STRINGS.get("IDSTR_EXCLUSIONS");
    static final String iGeneralOptions = MusicClient.STRINGS.get("IDSTR_GENERALOPTIONS");
    static final String iMixOptions = MusicClient.STRINGS.get("IDSTR_MIXOPTIONS");
    static final String iPlaylistView = MusicClient.STRINGS.get("IDSTR_PLAYLISTVIEW");
    static final String iServerOptions = MusicClient.STRINGS.get("IDSTR_SERVEROPTIONS");
    static final String iServices = MusicClient.STRINGS.get("IDSTR_SERVICES");
    static final String iShuffle = MusicClient.STRINGS.get("IDSTR_SHUFFLE");
    MusicClient client;
    ApplicationsPanel applicationsPanel;
    ExclusionsPanel exclusionsPanel;
    GeneralOptions generalOptions;
    PlaylistOptions mixOptions;
    TableConfigurationPanel playlistView;
    LibraryOptions serverPanel;
    ServicesPanel servicesPanel;
    ShufflePanel shufflePanel;
    static int defaultTab = 3;

    public ConfigDialog(MusicClient musicClient) {
        super(musicClient, MusicClient.STRINGS.get("IDSTR_J_PREFRENCES"), true);
        this.client = musicClient;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfigDialog.this.client.enableMenus(true);
            }
        });
        this.applicationsPanel = new ApplicationsPanel();
        this.mixOptions = new PlaylistOptions(this.client);
        this.playlistView = new TableConfigurationPanel(this.client);
        this.serverPanel = new LibraryOptions(this.client);
        this.generalOptions = new GeneralOptions(this.client);
        this.servicesPanel = new ServicesPanel(this.client);
        this.shufflePanel = new ShufflePanel(this.client);
        this.exclusionsPanel = new ExclusionsPanel(this.client);
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        final JPanel jPanel2 = new JPanel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return new Dimension(500, 300);
            }
        };
        jPanel2.setBorder(new BevelBorder(0));
        jPanel.add("Center", jPanel2);
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        defaultListModel.addElement(iApplications);
        defaultListModel.addElement(iExclusions);
        defaultListModel.addElement(iGeneralOptions);
        defaultListModel.addElement(iMixOptions);
        defaultListModel.addElement(iPlaylistView);
        defaultListModel.addElement(iServerOptions);
        defaultListModel.addElement(iServices);
        defaultListModel.addElement(iShuffle);
        final JList jList = new JList(defaultListModel){

            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 300);
            }
        };
        jList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                jPanel2.invalidate();
                jPanel2.removeAll();
                defaultTab = jList.getSelectedIndex();
                if (defaultTab < 0 || defaultTab > 7) {
                    defaultTab = 2;
                }
                switch (defaultTab) {
                    case 0: {
                        jPanel2.add(ConfigDialog.this.applicationsPanel);
                        break;
                    }
                    case 1: {
                        jPanel2.add(ConfigDialog.this.exclusionsPanel);
                        break;
                    }
                    case 2: {
                        jPanel2.add(ConfigDialog.this.generalOptions);
                        break;
                    }
                    case 3: {
                        jPanel2.add(ConfigDialog.this.mixOptions);
                        break;
                    }
                    case 4: {
                        jPanel2.add(ConfigDialog.this.playlistView);
                        break;
                    }
                    case 5: {
                        jPanel2.add(ConfigDialog.this.serverPanel);
                        break;
                    }
                    case 6: {
                        jPanel2.add(ConfigDialog.this.servicesPanel);
                        break;
                    }
                    case 7: {
                        jPanel2.add(ConfigDialog.this.shufflePanel);
                    }
                }
                jPanel2.revalidate();
                jPanel2.repaint();
            }
        });
        jPanel.add("West", new JScrollPane(jList));
        jList.setSelectedIndex(defaultTab);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(MusicClient.iOK);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigDialog.this.applicationsPanel.apply();
                ConfigDialog.this.mixOptions.apply();
                ConfigDialog.this.playlistView.apply();
                ConfigDialog.this.serverPanel.apply();
                ConfigDialog.this.generalOptions.apply();
                ConfigDialog.this.servicesPanel.apply();
                ConfigDialog.this.shufflePanel.apply();
                ConfigDialog.this.exclusionsPanel.apply();
                ConfigDialog.this.setVisible(false);
                ConfigDialog.this.client.enableMenus(true);
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton(MusicClient.iCancel);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigDialog.this.setVisible(false);
                ConfigDialog.this.client.enableMenus(true);
            }
        });
        jPanel3.add(jButton2);
        jPanel.add("South", jPanel3);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.client);
        this.setResizable(false);
        this.setVisible(true);
    }
}

