/*
 * Decompiled with CFR 0.152.
 */
package music.cpp.client;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import music.cpp.client.Label2;
import music.cpp.client.MusicClient;

public class ApplicationsPanel
extends JPanel {
    JTextField player;
    JTextField fileManager;
    JTextField browser;
    JTextField mailClient;
    public static final String iPlayer = MusicClient.STRINGS.get("IDSTR_J_PLAYER");
    public static final String iFileManager = MusicClient.STRINGS.get("IDSTR_J_FILE_MANAGER");
    public static final String iBrowser = MusicClient.STRINGS.get("IDSTR_J_BROWSER");
    public static final String iMailClient = MusicClient.STRINGS.get("IDSTR_J_MAIL_CLIENT");
    public static final String iBrowse = MusicClient.STRINGS.get("IDSTR_J_BROWSE");

    public ApplicationsPanel() {
        super(new GridBagLayout());
        this.setOpaque(false);
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Label2 label2 = new Label2(iPlayer + ": ");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.player = new JTextField(MusicClient.getPlayer());
        gridBagLayout.setConstraints(this.player, gridBagConstraints);
        this.add(this.player);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        JButton jButton = this.createBrowseButton(iPlayer);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        label2 = new Label2(iFileManager + ": ");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.fileManager = new JTextField(MusicClient.getFileManager());
        gridBagLayout.setConstraints(this.fileManager, gridBagConstraints);
        this.add(this.fileManager);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jButton = this.createBrowseButton(iFileManager);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        label2 = new Label2(iBrowser + ": ");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.browser = new JTextField(MusicClient.getBrowser());
        gridBagLayout.setConstraints(this.browser, gridBagConstraints);
        this.add(this.browser);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jButton = this.createBrowseButton(iBrowser);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        label2 = new Label2(iMailClient + ": ");
        gridBagLayout.setConstraints(label2, gridBagConstraints);
        this.add(label2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.mailClient = new JTextField(MusicClient.getMailClient());
        gridBagLayout.setConstraints(this.mailClient, gridBagConstraints);
        this.add(this.mailClient);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jButton = this.createBrowseButton(iMailClient);
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.add(jButton);
    }

    JButton createBrowseButton(final String string) {
        JButton jButton = new JButton(iBrowse);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle(MusicClient.STRINGS.expand("IDSTR_J_SELECT", new String[]{string}));
                if (jFileChooser.showOpenDialog(ApplicationsPanel.this) == 0) {
                    String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                    if (iPlayer.equals(string)) {
                        ApplicationsPanel.this.player.setText(string2);
                    } else if (iFileManager.equals(string)) {
                        ApplicationsPanel.this.fileManager.setText(string2);
                    } else if (iBrowser.equals(string)) {
                        ApplicationsPanel.this.browser.setText(string2);
                    } else if (iMailClient.equals(string)) {
                        ApplicationsPanel.this.mailClient.setText(string2);
                    }
                }
            }
        });
        return jButton;
    }

    void apply() {
        MusicClient.setPlayer(this.player.getText());
        MusicClient.setFileManager(this.fileManager.getText());
        MusicClient.setBrowser(this.browser.getText());
        MusicClient.setMailClient(this.mailClient.getText());
    }
}

