#    Copyright 2003,2008 Regis Damongeot

#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

proc proc_add_excluded_f_d { files_list } {
	global excluded_file_list option_auto_refresh_space i18n_error i18n_error_file_not_present i18n_error_directory_not_present i18n_error_adding_ef
	#if user click on cancel, returned list = ""
	if { $files_list != "" } {
		#foreach needed for multiple files selection
		foreach i $files_list {
			set file_present [file_is_present_or_conatained "$i"]
			set file_present_efl [file_is_present_or_conatained_in_efl "$i"]
			if { $file_present == "no" } {
				if { [file isfile $i] } {
					tk_messageBox -icon error -message "$i18n_error_file_not_present" -type ok -title $i18n_error
				} elseif { [file isdirectory $i] } {
					tk_messageBox -icon error -message "$i18n_error_directory_not_present" -type ok -title $i18n_error
				}
			} else {
				#check if file is not already in excluded file list or contains/contained in (see ile_is_present_or_conatained_in_efl procedure)
				if { $file_present_efl != "no" } {
					tk_messageBox -icon error -message "$i18n_error_adding_ef: $i" -type ok -title $i18n_error
				} else {
					lappend excluded_file_list $i
				}
			}
		}
		
		if { $option_auto_refresh_space == "1" } {
			refresh_total_file_size
		}
		refresh_cmd_line
	} else {
	#puts "No file or dir chosen"
	}
}

proc delete_excluded_files {} {
	global excluded_file_list option_auto_refresh_space
	if { "[.excluded_file_window.file_list.list curselection]" == "" } {
	} else {
		set excluded_file_list [lreplace $excluded_file_list [.excluded_file_window.file_list.list curselection] [.excluded_file_window.file_list.list curselection]]
		#refresh command line entry after checking space used to check overburn condition
		if { $option_auto_refresh_space == "1" } {
			refresh_total_file_size
		}
		refresh_cmd_line
	}
}

proc excluded_file_window {} {
	global excluded_file_list
	#i18n
	global i18n_add_files i18n_add_directory i18n_delete_file_dir i18n_clear_list i18n_close i18n_excluded_files_and_dir
if { ! [winfo exists .excluded_file_window] } {
	toplevel .excluded_file_window -highlightthickness 1 -highlightcolor blue -background #f5f5f5
	wm title .excluded_file_window "$i18n_excluded_files_and_dir"
	frame .excluded_file_window.f_buttons
	button .excluded_file_window.f_buttons.b_add_files -highlightbackground red -width 13 -text "$i18n_add_files" -command { proc_add_excluded_f_d [tk_getOpenFile -multiple 1] }
	button .excluded_file_window.f_buttons.b_add_dir -highlightbackground red -width 13 -text "$i18n_add_directory" -command { proc_add_excluded_f_d "{[tk_chooseDirectory -mustexist true]}" }
	button .excluded_file_window.f_buttons.b_del -highlightbackground red -width 13 -text "$i18n_delete_file_dir" -command { delete_excluded_files }
	button .excluded_file_window.f_buttons.b_clear -highlightbackground red -width 13 -text "$i18n_clear_list" -command { set excluded_file_list ""; refresh_total_file_size; refresh_cmd_line }
	button .excluded_file_window.f_buttons.b_close -highlightbackground red -width 13 -text "$i18n_close" -command {destroy .excluded_file_window}
	pack .excluded_file_window.f_buttons.b_add_files .excluded_file_window.f_buttons.b_add_dir .excluded_file_window.f_buttons.b_del .excluded_file_window.f_buttons.b_clear .excluded_file_window.f_buttons.b_close -side left
	pack .excluded_file_window.f_buttons -side top
	
	frame .excluded_file_window.file_list
	listbox .excluded_file_window.file_list.list -bg #f5f5f5 -listvariable excluded_file_list -heigh 15 -yscrollcommand { .excluded_file_window.file_list.scroll_bar set }
	scrollbar .excluded_file_window.file_list.scroll_bar -command { .file_list.list yview }
	pack .excluded_file_window.file_list.scroll_bar -side right -fill y
	pack .excluded_file_window.file_list.list -fill x
	pack .excluded_file_window.file_list -fill both -expand false -side bottom
}
}
