/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.NumberHashMap;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.framebody.AbstractID3v2FrameBody;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;

public class FrameBodyTIPL
extends AbstractID3v2FrameBody
implements ID3v24FrameBody {
    public static final String ENGINEER = "engineer";
    public static final String MIXER = "mix";
    public static final String DJMIXER = "DJ-mix";
    public static final String PRODUCER = "producer";
    public static final String ARRANGER = "arranger";

    public FrameBodyTIPL() {
        this.setObjectValue("TextEncoding", (byte)0);
    }

    public FrameBodyTIPL(byte textEncoding, String text) {
        this.setObjectValue("TextEncoding", textEncoding);
        this.setText(text);
    }

    public FrameBodyTIPL(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public FrameBodyTIPL(FrameBodyIPLS body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        this.setObjectValue("Text", body.getPairing());
    }

    public String getIdentifier() {
        return "TIPL";
    }

    public void setText(String text) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = new PairedTextEncodedStringNullTerminated.ValuePairs();
        StringTokenizer stz = new StringTokenizer(text, "\u0000");
        while (stz.hasMoreTokens()) {
            String key = stz.nextToken();
            if (!stz.hasMoreTokens()) continue;
            value.add(key, stz.nextToken());
        }
        this.setObjectValue("Text", value);
    }

    public void addPair(String text) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        StringTokenizer stz = new StringTokenizer(text, "\u0000");
        if (stz.countTokens() == 2) {
            this.addPair(stz.nextToken(), stz.nextToken());
        }
    }

    public void addPair(String function, String name) {
        PairedTextEncodedStringNullTerminated.ValuePairs value = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        value.add(function, name);
    }

    public void resetPairs() {
        PairedTextEncodedStringNullTerminated.ValuePairs value = ((PairedTextEncodedStringNullTerminated)this.getObject("Text")).getValue();
        value.getMapping().clear();
    }

    public void write(ByteArrayOutputStream tagBuffer) {
        if (!((PairedTextEncodedStringNullTerminated)this.getObject("Text")).canBeEncoded()) {
            this.setTextEncoding((byte)1);
        }
        super.write(tagBuffer);
    }

    protected void setupObjectList() {
        this.objectList.add(new NumberHashMap("TextEncoding", (AbstractTagFrameBody)this, 1));
        this.objectList.add(new PairedTextEncodedStringNullTerminated("Text", this));
    }

    public PairedTextEncodedStringNullTerminated.ValuePairs getPairing() {
        return (PairedTextEncodedStringNullTerminated.ValuePairs)this.getObject("Text").getValue();
    }

    public String getKeyAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getMapping().get(index).getKey();
    }

    public String getValueAtIndex(int index) {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getMapping().get(index).getValue();
    }

    public int getNumberOfPairs() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        return text.getValue().getNumberOfPairs();
    }

    public String getText() {
        PairedTextEncodedStringNullTerminated text = (PairedTextEncodedStringNullTerminated)this.getObject("Text");
        StringBuilder sb = new StringBuilder();
        int count = 1;
        for (Pair entry : text.getValue().getMapping()) {
            sb.append(entry.getKey() + '\u0000' + entry.getValue());
            if (count != this.getNumberOfPairs()) {
                sb.append('\u0000');
            }
            ++count;
        }
        return sb.toString();
    }

    public String getUserFriendlyValue() {
        return this.getText();
    }
}

