/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action.browse;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Playlist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.web.browse.TPlaylist;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Playlister
extends WebAction {
    @Override
    public void handleRequest() throws SQLException, IOException, BadRequestException {
        Request req = this.getRequest();
        String type = req.getUrlParam(1);
        if (!type.equals("playlist")) {
            throw new BadRequestException("unknown browse type '" + type + "'", 400);
        }
        this.playlist();
    }

    protected void playlist() throws SQLException, IOException, BadRequestException {
        Request req = this.getRequest();
        int id = Integer.parseInt(req.getUrlParam(2));
        Playlist playlist = this.getPlaylist(id);
        Vector<Track> tracks = this.getPlaylistTracks(id);
        this.showPlaylist(playlist, tracks);
    }

    protected void showPlaylist(Playlist playlist, Vector<Track> tracks) throws IOException, SQLException {
        TPlaylist tpl = new TPlaylist();
        tpl.setTracks(tracks);
        tpl.setPlaylist(playlist);
        this.getResponse().showHtml(tpl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getPlaylistTracks(int playlistId) throws SQLException {
        Vector<Track> vector;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = Playlist.getSelectTracksSql(playlistId, "");
            st = db.prepare(sql);
            rs = st.executeQuery();
            vector = Track.createVectorFromResultSet(rs);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Playlist getPlaylist(int id) throws SQLException, BadRequestException {
        Playlist playlist;
        ResultSet rs = null;
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select p.id as id, p.name as name  from playlists p  where p.id = ?  limit 1 ";
            st = db.prepare(" select p.id as id, p.name as name  from playlists p  where p.id = ?  limit 1 ");
            st.setInt(1, id);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new BadRequestException("playlist not found", 404);
            }
            playlist = new Playlist(rs.getInt("id"), rs.getString("name"));
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return playlist;
    }
}

