/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.TRSSLatest;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Feeder
extends WebAction {
    private final String host;

    public Feeder(String host) {
        this.host = host;
    }

    @Override
    public void handleRequest() throws SQLException, IOException, BadRequestException {
        Request req = this.getRequest();
        String type = req.getUrlParam(1);
        if (!type.equals("latest")) {
            throw new BadRequestException("Unknown feed type (" + type + ")", 400);
        }
        this.latest(this.getLatestTracks(20));
    }

    public void latest(Vector<Track> tracks) throws SQLException, IOException {
        TRSSLatest tpl = new TRSSLatest();
        tpl.setProperties(this.getProperties());
        tpl.setHost(this.host);
        tpl.setTracks(tracks);
        this.getResponse().showRss(tpl.makeRenderer());
    }
}

