/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Playlist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.templates.web.browse.TPlaylist;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TPlaylistImpl
extends AbstractTemplateImpl
implements TPlaylist.Intf {
    private final Playlist playlist;
    private final Vector<Track> tracks;
    private final Properties properties;
    private final Vector<User> recentUsers;
    private final Locale locale;
    private final User user;

    protected static TPlaylist.ImplData __jamon_setOptionalArguments(TPlaylist.ImplData p_implData) {
        if (!p_implData.getPlaylist__IsNotDefault()) {
            p_implData.setPlaylist(null);
        }
        if (!p_implData.getTracks__IsNotDefault()) {
            p_implData.setTracks(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        return p_implData;
    }

    public TPlaylistImpl(TemplateManager p_templateManager, TPlaylist.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TPlaylistImpl.__jamon_setOptionalArguments(p_implData));
        this.playlist = p_implData.getPlaylist();
        this.tracks = p_implData.getTracks();
        this.properties = p_implData.getProperties();
        this.recentUsers = p_implData.getRecentUsers();
        this.locale = p_implData.getLocale();
        this.user = p_implData.getUser();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_43 = new IHeader(this.getTemplateManager());
        __jamon__var_43.setProperties(this.properties);
        __jamon__var_43.setTitle("Playlist: " + this.playlist.getName());
        __jamon__var_43.setLocale(this.locale);
        __jamon__var_43.setUser(this.user);
        __jamon__var_43.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<h2>\n    <div class=\"links\">\n        ");
        Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(this.playlist.getName())), jamonWriter);
        jamonWriter.write("\n        <div class=\"links\">\n            ");
        IMusicLinks __jamon__var_44 = new IMusicLinks(this.getTemplateManager());
        __jamon__var_44.setName(this.playlist.getName());
        __jamon__var_44.setShareLink(true);
        __jamon__var_44.setId(this.playlist.getId());
        __jamon__var_44.setPlayRandomLink(true);
        __jamon__var_44.setProperties(this.properties);
        __jamon__var_44.setLocale(this.locale);
        __jamon__var_44.setType("pl");
        __jamon__var_44.renderNoFlush(jamonWriter);
        jamonWriter.write("\n        </div>\n    </div>\n</h2>\n\n<br />\n\n<ul class=\"musiclist\">\n");
        if (this.tracks.size() > 0) {
            jamonWriter.write("\n    ");
            for (Track track : this.tracks) {
                jamonWriter.write("\n        <li class=\"track\">\n            ");
                IMusicLinks __jamon__var_45 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_45.setName(track.getName());
                __jamon__var_45.setId(track.getId());
                __jamon__var_45.setProperties(this.properties);
                __jamon__var_45.setLocale(this.locale);
                __jamon__var_45.setType("tr");
                __jamon__var_45.renderNoFlush(jamonWriter);
                jamonWriter.write("\n            <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/artist/" + track.getArtist().getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getArtist().getName())), jamonWriter);
                jamonWriter.write("</a> -\n            <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/album/" + track.getAlbum().getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getAlbum().getName())), jamonWriter);
                jamonWriter.write("</a> -\n            <span class=\"link\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getName())), jamonWriter);
                jamonWriter.write("</span>\n        </li>\n    ");
            }
            jamonWriter.write("\n");
        } else {
            jamonWriter.write("\n    <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n");
        }
        jamonWriter.write("\n</ul>\n\n");
        IFooter __jamon__var_46 = new IFooter(this.getTemplateManager());
        __jamon__var_46.setUser(this.user);
        __jamon__var_46.setProperties(this.properties);
        __jamon__var_46.setRecentUsers(this.recentUsers);
        __jamon__var_46.setLocale(this.locale);
        __jamon__var_46.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

