/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Album;
import com.pugh.sockso.music.Artist;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.templates.web.browse.TLatest;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TLatestImpl
extends AbstractTemplateImpl
implements TLatest.Intf {
    private final Vector<Track> tracks;
    private final Locale locale;
    private final User user;
    private final Properties properties;
    private final Vector<User> recentUsers;
    private final Vector<Album> albums;
    private final Vector<Artist> artists;

    protected static TLatest.ImplData __jamon_setOptionalArguments(TLatest.ImplData p_implData) {
        if (!p_implData.getTracks__IsNotDefault()) {
            p_implData.setTracks(null);
        }
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getAlbums__IsNotDefault()) {
            p_implData.setAlbums(null);
        }
        if (!p_implData.getArtists__IsNotDefault()) {
            p_implData.setArtists(null);
        }
        return p_implData;
    }

    public TLatestImpl(TemplateManager p_templateManager, TLatest.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TLatestImpl.__jamon_setOptionalArguments(p_implData));
        this.tracks = p_implData.getTracks();
        this.locale = p_implData.getLocale();
        this.user = p_implData.getUser();
        this.properties = p_implData.getProperties();
        this.recentUsers = p_implData.getRecentUsers();
        this.albums = p_implData.getAlbums();
        this.artists = p_implData.getArtists();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_38 = new IHeader(this.getTemplateManager());
        __jamon__var_38.setProperties(this.properties);
        __jamon__var_38.setTitle("Latest Music");
        __jamon__var_38.setLocale(this.locale);
        __jamon__var_38.setUser(this.user);
        __jamon__var_38.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<h2>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.latestTracks")), jamonWriter);
        jamonWriter.write("</h2>\n\n<ul class=\"musiclist\">\n");
        if (this.tracks.size() > 0) {
            jamonWriter.write("\n    ");
            for (Track track : this.tracks) {
                jamonWriter.write("\n        <li class=\"track\">\n            ");
                IMusicLinks __jamon__var_39 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_39.setName(track.getName());
                __jamon__var_39.setId(track.getId());
                __jamon__var_39.setProperties(this.properties);
                __jamon__var_39.setLocale(this.locale);
                __jamon__var_39.setType("tr");
                __jamon__var_39.renderNoFlush(jamonWriter);
                jamonWriter.write("\n            <span class=\"link\">\n                <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/artist/" + track.getArtist().getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getArtist().getName())), jamonWriter);
                jamonWriter.write("</a>\n                - ");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(track.getName())), jamonWriter);
                jamonWriter.write("\n            </span>\n        </li>\n    ");
            }
            jamonWriter.write("\n");
        } else {
            jamonWriter.write("\n    <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n");
        }
        jamonWriter.write("\n</ul>\n\n");
        if (this.artists.size() > 0) {
            jamonWriter.write("\n<div class=\"albumArt\">\n\n    <h2>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.latestArtists")), jamonWriter);
            jamonWriter.write("</h2>\n\n    <ul>\n        ");
            for (Artist artist : this.artists) {
                jamonWriter.write("\n            <li>\n                <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/artist/" + artist.getId())), jamonWriter);
                jamonWriter.write("\" title=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(artist.getName())), jamonWriter);
                jamonWriter.write("\"><img class=\"cover\" src=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/file/cover/ar" + artist.getId())), jamonWriter);
                jamonWriter.write("\" /></a>\n                <div class=\"links\">\n                    ");
                IMusicLinks __jamon__var_40 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_40.setName(artist.getName());
                __jamon__var_40.setId(artist.getId());
                __jamon__var_40.setProperties(this.properties);
                __jamon__var_40.setLocale(this.locale);
                __jamon__var_40.setType("ar");
                __jamon__var_40.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                </div>\n            </li>\n        ");
            }
            jamonWriter.write("\n    </ul>\n\n</div>\n");
        }
        jamonWriter.write("\n\n<div class=\"clearer\"></div>\n\n");
        if (this.albums.size() > 0) {
            jamonWriter.write("\n<div class=\"albumArt\">\n\n    <h2>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.latestAlbums")), jamonWriter);
            jamonWriter.write("</h2>\n\n    <ul>\n        ");
            for (Album album : this.albums) {
                jamonWriter.write("\n            <li>\n                <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/album/" + album.getId())), jamonWriter);
                jamonWriter.write("\" title=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(album.getName())), jamonWriter);
                jamonWriter.write("\"><img class=\"cover\" src=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/file/cover/al" + album.getId())), jamonWriter);
                jamonWriter.write("\" /></a>\n                <div class=\"links\">\n                    ");
                IMusicLinks __jamon__var_41 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_41.setName(album.getName());
                __jamon__var_41.setId(album.getId());
                __jamon__var_41.setProperties(this.properties);
                __jamon__var_41.setLocale(this.locale);
                __jamon__var_41.setType("al");
                __jamon__var_41.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                </div>\n            </li>\n        ");
            }
            jamonWriter.write("\n    </ul>\n\n</div>\n");
        }
        jamonWriter.write("\n\n");
        IFooter __jamon__var_42 = new IFooter(this.getTemplateManager());
        __jamon__var_42.setUser(this.user);
        __jamon__var_42.setProperties(this.properties);
        __jamon__var_42.setRecentUsers(this.recentUsers);
        __jamon__var_42.setLocale(this.locale);
        __jamon__var_42.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

